package com.biz.crm.cps.external.mdm.sdk.vo;

import com.bizunited.nebula.common.vo.TenantOpVo;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author hecheng
 * @description: mdm商品物料关系vo
 * @date 2021/8/9 下午7:13
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class ProductMaterialMdmVo extends TenantOpVo {
  private static final long serialVersionUID = 2915678946805385585L;

  @ApiModelProperty("id")
  private String id;

  /**
   * 物料数量
   */
  @ApiModelProperty("物料数量")
  private Integer num;

  /**
   * 物料编码
   */
  @ApiModelProperty("物料编码")
  private String materialCode;

  /**
   * 商品编码
   */
  @ApiModelProperty("商品编码")
  private String productCode;

  /**
   * 比例
   */
  @ApiModelProperty("比例")
  private BigDecimal ratio;

  /**
   * 数据状态（删除状态） 003 删除 009 正常
   */
  @ApiModelProperty("数据状态")
  private String delFlag;

  /**
   * 数据业务状态（启用状态） 003 禁用 009 启用
   */
  @ApiModelProperty("启用状态")
  private String enableStatus;
  /**
   * 物料信息
   */
  @ApiModelProperty("物料信息")
  private MaterialMdmVo material;

}
