package com.biz.crm.cps.external.mdm.sdk.vo;

import com.bizunited.nebula.common.vo.TenantOpVo;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import java.util.Set;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author hecheng
 * @description: mdm商品vo
 * @date 2021/8/9 下午7:13
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class ProductMdmVo extends TenantOpVo {
  private static final long serialVersionUID = -9221958989450424826L;
  
  @ApiModelProperty("id")
  private String id;
  /**
   * 商品编码
   */
  @ApiModelProperty("商品编码")
  private String productCode;

  /**
   * 商品名称
   */
  @ApiModelProperty("商品名称")
  private String productName;

  /**
   * 产品层级编码
   */
  @ApiModelProperty("产品层级编码")
  private String productLevelCode;

  /**
   * 商品类型(数据字典)
   * <pre>"gift_package":"礼包商品"
   * "range":"范围商品"
   * "standard":"标准商品"</pre>
   */
  @ApiModelProperty("商品类型")
  private String productType;

  /**
   * 上下架状态(数据字典) "Y","上架"；"N","下架"
   */
  @ApiModelProperty("上下架状态")
  private String isShelf;

  /**
   * 条形码
   */
  @ApiModelProperty("条形码")
  private String barCode;

  /**
   * 销售公司
   */
  @ApiModelProperty("销售公司")
  private String saleCompany;

  /**
   * 主图片url
   */
  @ApiModelProperty("主图片url")
  private String primaryPictureUrl;

  /**
   * 销售单位
   */
  @ApiModelProperty("销售单位")
  private String saleUnit;

  /**
   * 规格
   */
  @ApiModelProperty("规格")
  private String spec;
  /**
   * 基本单位
   */
  @ApiModelProperty("基本单位")
  private String baseUnit;
  /**
   * 数据状态（删除状态） 003 删除 009 正常
   */
  @ApiModelProperty("数据状态")
  private String delFlag;

  /**
   * 数据业务状态（启用状态） 003 禁用 009 启用
   */
  @ApiModelProperty("启用状态")
  private String enableStatus;

  /**
   * 商品层级集合 （指本商品所属层级 所有父节点的信息 包括自己）
   */
  @ApiModelProperty("商品层级集合")
  private List<ProductLevelMdmVo> productLevels;

  /**
   * 商品与物料关系
   */
  @ApiModelProperty("商品与物料关系")
  private Set<ProductMaterialMdmVo> productMaterials;
}
