package com.biz.crm.cps.external.mdm.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantOpVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.math.BigDecimal;
import java.util.List;

@Data
@ToString
@EqualsAndHashCode(callSuper = false)
public class TerminalMdmVo extends TenantOpVo {
  private static final long serialVersionUID = 5950487053016325725L;

  /**
   * 高德地图id
   */
  @ApiModelProperty("高德地图ID")
  private String amapId;

  /**
   * 终端编码
   */
  @ApiModelProperty("终端编码")
  private String terminalCode;

  /**
   * 终端名称
   */
  @ApiModelProperty("终端名称")
  private String terminalName;

  /**
   * 终端类型
   */
  @ApiModelProperty("终端类型")
  private String terminalType;

  /**
   * 终端类型名称
   */
  @ApiModelProperty("终端类型名称")
  private String terminalTypeName;

  /**
   * 所属组织编码
   */
  @ApiModelProperty("所属组织编码")
  private String orgCode;

  /**
   * 所属组织名字
   */
  @ApiModelProperty("所属组织名字")
  private String orgName;

  /**
   * 客户组织编码
   */
  @ApiModelProperty("客户组织编码")
  private String customerOrgCode;
  /**
   * 客户组织名称
   */
  @ApiModelProperty("客户组织名称")
  private String customerOrgName;

  /**
   * 渠道
   */
  @ApiModelProperty("渠道")
  private String channel;

  /**
   * 渠道名字
   */
  @ApiModelProperty("渠道名字")
  private String channelName;

  /**
   * 营业执照法人姓名
   */
  @ApiModelProperty("营业执照法人姓名")
  private String licensePersonName;

  /**
   * 营业执照注册号
   */
  @ApiModelProperty("营业执照注册号")
  private String licenseRegisterNumber;

  /**
   * 营业执照企业名称
   */
  @ApiModelProperty("营业执照企业名称")
  private String licenseFirmName;

  /**
   * 终端地址
   */
  @ApiModelProperty("终端地址")
  private String terminalAddress;

  /**
   * 省编码
   */
  @ApiModelProperty("省编码")
  private String provinceCode;

  /**
   * 市编码
   */
  @ApiModelProperty("市编码")
  private String cityCode;

  /**
   * 区编码
   */
  @ApiModelProperty("区编码")
  private String districtCode;

  /**
   * 省名称
   */
  @ApiModelProperty("省名称")
  private String provinceName;

  /**
   * 市名称
   */
  @ApiModelProperty("市名称")
  private String cityName;

  /**
   * 区名称
   */
  @ApiModelProperty("区名称")
  private String districtName;

  /**
   * 店招照片
   */
  @ApiModelProperty("店招照片")
  private String shopImagePath;

  /**
   * 营业执照照片
   */
  @ApiModelProperty("营业执照照片")
  private String licenseImagePath;

  /**
   * 经度
   */
  @ApiModelProperty("经度")
  private BigDecimal longitude;

  /**
   * 纬度
   */
  @ApiModelProperty("纬度")
  private BigDecimal latitude;

  /**
   * 客户分类
   */
  @ApiModelProperty("客户分类")
  private String customerClassification;

  /**
   * 审批状态
   */
  @ApiModelProperty("审批状态,枚举MdmBpmStatusEnum")
  private String actApproveStatus;

  /**
   * 审批状态名称
   */
  @ApiModelProperty("审批状态名称")
  private String actApproveStatusName;

  /**
   * 合作状态
   */
  @ApiModelProperty("合作状态")
  private String cooperateStatus;

  /**
   * KMS关联客户门店id
   */
  @ApiModelProperty("kms关联客户门店id")
  private String storeId;

  /**
   * KMS直营体系id
   */
  @ApiModelProperty("kms直营体系id")
  private String directSystemId;

  /**
   * KMS售达方id
   */
  @ApiModelProperty("kms售达方id")
  private String sellPartyId;

  /**
   * 审批类型
   */
  @ApiModelProperty("审批类型")
  private String approvalType;

  /**
   * 流程编号
   */
  @ApiModelProperty("流程编号")
  private String processCode;

  /**
   * 流程KEY
   */
  @ApiModelProperty("流程key")
  private String workFlowKey;

  /**
   * 主题
   */
  @ApiModelProperty("主题")
  private String title;

  /**
   * 业务来源系统
   */
  @ApiModelProperty("业务来源系统")
  private String fromType;

  /**
   * 审批备注
   */
  @ApiModelProperty("审批备注")
  private String approveRemarks;

  /**
   * 审批配置业务编码
   */
  @ApiModelProperty(value = "审批配置业务编码")
  private String approvalBusinessCode;

  /**
   * 数据来源
   */
  @ApiModelProperty("数据来源")
  private String sourceType;

  /**
   * 标签描述
   */
  @ApiModelProperty("标签描述")
  private String tagDescription;

  /**
   * 渠道编码集合
   */
  @ApiModelProperty("渠道编码集合")
  private List<String> channelList;

  /**
   * 关联联系人信息
   */
  @ApiModelProperty("联系人信息集合")
  private List<TerminalContactMdmVo> contacts;

  /**
   * 客户组织编码
   */
  @ApiModelProperty("供货关系集合")
  private List<TerminalSupplyVo> supplys;

  /**
   * 终端关联组织集合
   */
  @ApiModelProperty("终端关联组织集合")
  private List<TerminalOrgMdmVo> orgList;

  @ApiModelProperty("终端关联客户组织集合")
  private List<TerminalRelaCustomerOrgVo> customerOrgList;
}
