package com.biz.crm.cps.external.mdm.sdk.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @author jerry7
 * @date 2021/7/29 19:29
 * 终端关联组织VO
 */
@Data
public class TerminalOrgMdmVo {
  /**
   * 组织编码
   */
  @ApiModelProperty("组织编码")
  private String orgCode;

  /**
   * 组织名称
   */
  @ApiModelProperty("组织名称")
  private String orgName;

  /**
   * 组织类型（字典mdm_org_type）
   */
  @ApiModelProperty("组织类型（字典mdm_org_type）")
  private String orgType;

  /**
   * 组织类型（orgType字段经过数据字典翻译后的值）
   */
  @ApiModelProperty("组织类型（orgType字段经过数据字典翻译后的值）")
  private String orgTypeName;

  /**
   * 组织描述
   */
  @ApiModelProperty("组织描述")
  private String orgDesc;

  /**
   * 上级组织编码
   */
  @ApiModelProperty("上级组织编码")
  private String parentCode;

  /**
   * 对应SAP组织编码
   */
  @ApiModelProperty("对应SAP组织编码")
  private String sapOrgCode;

  /**
   * 对应SAP组织编码利润中心编码
   */
  @ApiModelProperty("对应SAP组织编码利润中心编码")
  private String sapProfitOrgCode;

  /**
   * 对应SAP组织编码成本中心编码
   */
  @ApiModelProperty("对应SAP组织编码成本中心编码")
  private String sapCostOrgCode;

  /**
   * 上级组织名称
   */
  @ApiModelProperty("上级组织名称")
  private String parentName;
}
