package com.biz.crm.cps.external.mdm.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 终端供货关系VO
 * @author jerry7
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class TerminalSupplyVo extends TenantFlagOpVo {

  /**
   * 供货关系类型
   */
  @ApiModelProperty("供货关系类型")
  private String supplyType;

  /**
   * 用户账号
   */
  @ApiModelProperty("用户账号")
  private String userName;

  /**
   * 终端编码
   */
  @ApiModelProperty("终端编码")
  private String terminalCode;
  /**
   * 组织编码
   */
  @ApiModelProperty("组织编码")
  private String orgCode;

  /**
   * 组织名称
   */
  @ApiModelProperty("组织名称")
  private String orgName;

  /**
   * 用户名称
   */
  @ApiModelProperty("用户名称")
  private String fullName;

  /**
   * 上级客户编码
   */
  @ApiModelProperty("上级客户编码")
  private String customerCode;

  /**
   * 上级客户名称
   */
  @ApiModelProperty("上级客户名称")
  private String customerName;

  /**
   * 职位编码
   */
  @ApiModelProperty("职位编码")
  private String positionCode;

  /**
   * 职位名称
   */
  @ApiModelProperty("职位名称")
  private String positionName;

  /**
   * 销售公司编码
   */
  @ApiModelProperty("销售公司编码")
  private String saleCompany;

  /**
   * 渠道
   */
  @ApiModelProperty("渠道")
  private String channel;

  /**
   * 渠道编码
   */
  @ApiModelProperty("渠道编码")
  private String channelName;

  /**
   * 供货关系明细
   */
  @ApiModelProperty("供货关系明细")
  private List<TerminalSupplyDetailVo> details;

}
