package com.biz.crm.cps.external.tax.raise.local.client.capital;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.common.local.model.Result;
import com.biz.crm.cps.external.tax.raise.local.client.base.AbstractTaxRaiseClient;
import com.biz.crm.cps.external.tax.raise.sdk.dto.base.MerchantAccountDto;
import com.biz.crm.cps.external.tax.raise.sdk.dto.capital.TaxDeductionAmountDto;
import com.biz.crm.cps.external.tax.raise.sdk.dto.capital.TaxRaiseCapitalAccountQueryDto;
import com.biz.crm.cps.external.tax.raise.sdk.vo.capital.TaxRaiseCapitalAccountVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

/**
 * 税筹资金账户信息client
 * @Author: wjx
 * @Date: 2022/3/23 17:11
 */
@Component
@Slf4j
public class TaxRaiseCapitalAccountClient extends AbstractTaxRaiseClient {

  /**
   * 资金账户分页列表
   *
   * @param dto      请求参数dto
   * @param pageable 分页信息
   * @return Page<TaxRaiseCapitalAccountVo> 资金账户分页列表
   */
  public Page<TaxRaiseCapitalAccountVo> findByConditions(Pageable pageable, TaxRaiseCapitalAccountQueryDto dto) {
    Result result = super.doGet("/v1/external/capital/rechargeAccount/findByConditions", dto, pageable);
    return JSON.parseObject(JSON.toJSONString(result.getResult()),Page.class);
  }

  /**
   * 通过商户账号信息获取账户资金信息
   * @param dto
   * @return
   */
  public TaxRaiseCapitalAccountVo findByMerchantUserAccount(MerchantAccountDto dto) {
    Result result = super.doGet("/v1/external/capital/rechargeAccount/findByMerchantUserAccount", dto,null);
    return JSON.parseObject(JSON.toJSONString(result.getResult()),TaxRaiseCapitalAccountVo.class);
  }

  /**
   * 扣减用户账户资金
   * @param dto
   */
  public void deductAmountByDeductionAmountDto(TaxDeductionAmountDto dto) {
    super.doPost("/v1/external/capital/rechargeAccount/deductAmountByDeductionAmountDto", dto);
  }
}
