package com.biz.crm.cps.external.tax.raise.local.client.capital;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.common.local.model.Result;
import com.biz.crm.cps.external.tax.raise.local.client.base.AbstractTaxRaiseClient;
import com.biz.crm.cps.external.tax.raise.sdk.dto.capital.TaxRaiseCapitalAccountTransactionQueryDto;
import com.biz.crm.cps.external.tax.raise.sdk.vo.capital.TaxRaiseCapitalAccountTransactionVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

/**
 * 税筹资金账户收支明细client
 * @Author: wjx
 * @Date: 2022/3/23 17:11
 */
@Component
@Slf4j
public class TaxRaiseCapitalAccountTransactionClient extends AbstractTaxRaiseClient {

  /**
   * 资金账户收支明细分页列表
   *
   * @param dto      请求参数dto
   * @param pageable 分页信息
   * @return Page<TaxRaiseCapitalAccountTransactionVo> 资金账户收支明细分页列表
   */
  public Page<TaxRaiseCapitalAccountTransactionVo> findByConditions(Pageable pageable, TaxRaiseCapitalAccountTransactionQueryDto dto) {
    Result result = super.doGet("/v1/external/capital/accountTransaction/findByConditions", dto, pageable);
    return JSON.parseObject(JSON.toJSONString(result.getResult()),Page.class);
  }
}
