package com.biz.crm.cps.external.tax.raise.local.client.capital;

import com.alibaba.fastjson.JSON;
import com.biz.crm.cps.business.common.local.model.Result;
import com.biz.crm.cps.external.tax.raise.local.client.base.AbstractTaxRaiseClient;
import com.biz.crm.cps.external.tax.raise.sdk.dto.capital.TaxRaiseMerchantRechargeInfoDto;
import com.biz.crm.cps.external.tax.raise.sdk.vo.capital.TaxRaiseMerchantRechargeInfoVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * 商户平台充值信息Client
 * @Author: wjx
 * @Date: 2022/3/30 21:47
 */
@Component
@Slf4j
public class TaxRaiseMerchantRechargeInfoClient extends AbstractTaxRaiseClient {

  /**
   * 获取当前商户充值信息
   * @return
   */
  public TaxRaiseMerchantRechargeInfoVo findByCurrentMerchant() {
    Result result = super.doGet("/v1/external/capital/merchantRechargeInfo/findByMerchantId", null,null);
    return JSON.parseObject(JSON.toJSONString(result.getResult()), TaxRaiseMerchantRechargeInfoVo.class);
  }

  /**
   * 根据商户平台充值信息编码查询
   * @return
   */
  public TaxRaiseMerchantRechargeInfoVo findByMerchantRechargeCode(TaxRaiseMerchantRechargeInfoDto dto) {
    Result result = super.doGet("/v1/external/capital/merchantRechargeInfo/findByMerchantRechargeInfoDto", dto,null);
    return JSON.parseObject(JSON.toJSONString(result.getResult()), TaxRaiseMerchantRechargeInfoVo.class);
  }
}
