package com.biz.crm.cps.external.tax.raise.local.client.capital;

import com.alibaba.fastjson.JSON;
import com.biz.crm.cps.business.common.local.model.Result;
import com.biz.crm.cps.external.tax.raise.local.client.base.AbstractTaxRaiseClient;
import com.biz.crm.cps.external.tax.raise.sdk.dto.capital.TaxRaisePaymentBatchDto;
import com.biz.crm.cps.external.tax.raise.sdk.vo.capital.TaxRaiseRechargeBatchVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * 税筹付款信息client
 * @Author: wjx
 * @Date: 2022/3/23 15:31
 */
@Component
@Slf4j
public class TaxRaisePaymentClient extends AbstractTaxRaiseClient {

  /**
   * 批量创建付款信息
   * @param taxRaisePaymentBatchDto
   * @return
   */
  public TaxRaiseRechargeBatchVo createBatch(TaxRaisePaymentBatchDto taxRaisePaymentBatchDto) {
    Result result = super.doPost("v1/external/capital/payment/createBatch", taxRaisePaymentBatchDto);
    return JSON.parseObject(JSON.toJSONString(result.getResult()), TaxRaiseRechargeBatchVo.class);
  }


}
