package com.biz.crm.cps.external.tax.raise.local.client.capital;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.common.local.model.Result;
import com.biz.crm.cps.external.tax.raise.local.client.base.AbstractTaxRaiseClient;
import com.biz.crm.cps.external.tax.raise.sdk.dto.capital.TaxRaiseRechargeBatchDto;
import com.biz.crm.cps.external.tax.raise.sdk.dto.capital.TaxRaiseRechargeDto;
import com.biz.crm.cps.external.tax.raise.sdk.dto.capital.TaxRaiseRechargeQueryDto;
import com.biz.crm.cps.external.tax.raise.sdk.vo.capital.TaxRaiseRechargeBatchVo;
import com.biz.crm.cps.external.tax.raise.sdk.vo.capital.TaxRaiseRechargeVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

/**
 * 税筹充值信息client
 * @Author: wjx
 * @Date: 2022/3/23 15:31
 */
@Component
@Slf4j
public class TaxRaiseRechargeClient extends AbstractTaxRaiseClient {

  /**
   * 创建充值信息
   * @param dto
   * @return
   */
  public TaxRaiseRechargeVo create(TaxRaiseRechargeDto dto) {
    Result result = super.doPost("v1/external/capital/recharge/create", dto);
    return JSON.parseObject(JSON.toJSONString(result.getResult()), TaxRaiseRechargeVo.class);
  }

  /**
   * 批量创建充值信息
   * @param taxRaiseRechargeBatchDto
   * @return
   */
  public TaxRaiseRechargeBatchVo createBatch(TaxRaiseRechargeBatchDto taxRaiseRechargeBatchDto) {
    Result result = super.doPost("v1/external/capital/recharge/createBatch", taxRaiseRechargeBatchDto);
    return JSON.parseObject(JSON.toJSONString(result.getResult()), TaxRaiseRechargeBatchVo.class);
  }

  /**
   * 分页查询充值信息
   * @param pageable
   * @param dto
   * @return
   */
  public Page<TaxRaiseRechargeVo> findByConditions(Pageable pageable, TaxRaiseRechargeQueryDto dto) {
    Result result = super.doGet("/v1/external/capital/recharge/findByConditions", dto, pageable);
    return JSON.parseObject(JSON.toJSONString(result.getResult()),Page.class);
  }

}
