package com.biz.crm.cps.external.tax.raise.local.client.recharge;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.common.local.model.Result;
import com.biz.crm.cps.external.tax.raise.local.client.base.AbstractTaxRaiseClient;
import com.biz.crm.cps.external.tax.raise.sdk.dto.base.MerchantAccountBatchDto;
import com.biz.crm.cps.external.tax.raise.sdk.dto.base.MerchantAccountDto;
import com.biz.crm.cps.external.tax.raise.sdk.dto.base.TaxRaiseCustomerDto;
import com.biz.crm.cps.external.tax.raise.sdk.dto.recharge.TaxRaiseRechargeAccountDto;
import com.biz.crm.cps.external.tax.raise.sdk.dto.recharge.TaxRaiseRechargeAccountPageDto;
import com.biz.crm.cps.external.tax.raise.sdk.vo.recharge.TaxRaiseRechargeAccountVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 税筹充值账号信息client
 *
 * @author ning.zhang
 * @date 2022/3/22
 */
@Component
@Slf4j
public class TaxRaiseRechargeAccountClient extends AbstractTaxRaiseClient {

  /**
   * 通过商户账号信息获取充值账号信息
   *
   * @param dto 请求参数dto
   * @return 充值账号信息
   */
  public TaxRaiseRechargeAccountVo findByMerchantAccountDto(MerchantAccountDto dto) {
    Result result = super.doGet("/v1/external/contract/rechargeAccount/findByMerchantAccountDto", dto, null);
    return JSON.parseObject(JSON.toJSONString(result.getResult()),TaxRaiseRechargeAccountVo.class);
  }

  /**
   * 通过商户账号信息批量获取充值账号信息
   *
   * @param dto 请求参数dto
   * @return 充值账号信息
   */
  public List<TaxRaiseRechargeAccountVo> findByMerchantAccountBatchDto(MerchantAccountBatchDto dto) {
    Result result = super.doGet("/v1/external/contract/rechargeAccount/findByMerchantAccountBatchDto", dto, null);
    return JSON.parseArray(JSON.toJSONString(result.getResult()),TaxRaiseRechargeAccountVo.class);
  }

  /**
   * 充值实名认证账号信息分页列表
   *
   * @param dto      请求参数dto
   * @param pageable 分页信息
   * @return Page<FadadaRechargeAccountReportVo> 充值实名认证账号信息分页列表
   */
  public Page<TaxRaiseRechargeAccountVo> findByConditions(Pageable pageable, TaxRaiseRechargeAccountPageDto dto) {
    Result result = super.doGet("/v1/external/contract/rechargeAccount/findByConditions", dto, pageable);
    return JSON.parseObject(JSON.toJSONString(result.getResult()),Page.class);
  }

  /**
   * 创建充值账号信息
   *
   * @param dto 请求参数dto
   * @return 充值账号信息
   */
  public TaxRaiseRechargeAccountVo create(TaxRaiseRechargeAccountDto dto) {
    Result result = super.doPost("/v1/external/contract/rechargeAccount/create", dto);
    return JSON.parseObject(JSON.toJSONString(result.getResult()),TaxRaiseRechargeAccountVo.class);
  }

  /**
   * 身份证批量下载zip
   *
   * @param dto 参数dto
   * @return 下载结果
   */
  public String downloadIdentification(TaxRaiseCustomerDto dto) {
    Result result = super.doGet("/v1/external/contract/rechargeAccount/downloadIdentification", dto, null);
    return String.valueOf(result.getResult());
  }

  /**
   * 营业执照批量下载zip
   *
   * @param dto 参数dto
   * @return 下载结果
   */
  public String downloadBusinessLicense(TaxRaiseCustomerDto dto) {
    Result result = super.doGet("/v1/external/contract/rechargeAccount/downloadBusinessLicense", dto, null);
    return String.valueOf(result.getResult());
  }
}
