package com.biz.crm.cps.external.tax.raise.local.client.recharge;

import com.alibaba.fastjson.JSON;
import com.biz.crm.cps.business.common.local.model.Result;
import com.biz.crm.cps.external.tax.raise.local.client.base.AbstractTaxRaiseClient;
import com.biz.crm.cps.external.tax.raise.sdk.dto.recharge.TaxRaiseRechargeContractSignDto;
import com.biz.crm.cps.external.tax.raise.sdk.vo.recharge.TaxRaiseRechargeContractSignVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * 税筹充值合同签署client
 *
 * @author ning.zhang
 * @date 2022/3/22
 */
@Component
@Slf4j
public class TaxRaiseRechargeContractSignClient extends AbstractTaxRaiseClient {

  /**
   * 获取账号充值合同签署信息
   *
   * @param dto 参数dto
   * @return 账号充值合同签署信息
   */
  public TaxRaiseRechargeContractSignVo findByTaxRaiseRechargeContractSignDto(TaxRaiseRechargeContractSignDto dto) {
    Result result = super.doGet("/v1/external/contract/rechargeContractSign/findByTaxRaiseRechargeContractSignDto", dto, null);
    return JSON.parseObject(JSON.toJSONString(result.getResult()), TaxRaiseRechargeContractSignVo.class);
  }

  /**
   * 充值合同签署
   *
   * @param dto 参数dto
   * @return 充值合同签署信息
   */
  public TaxRaiseRechargeContractSignVo create(TaxRaiseRechargeContractSignDto dto) {
    Result result = super.doPost("/v1/external/contract/rechargeContractSign/create", dto);
    return JSON.parseObject(JSON.toJSONString(result.getResult()), TaxRaiseRechargeContractSignVo.class);
  }
}
