package com.biz.crm.cps.external.tax.raise.local.client.recharge;

import com.alibaba.fastjson.JSON;
import com.biz.crm.cps.business.common.local.model.Result;
import com.biz.crm.cps.external.tax.raise.local.client.base.AbstractTaxRaiseClient;
import com.biz.crm.cps.external.tax.raise.sdk.dto.base.MerchantAccountDto;
import com.biz.crm.cps.external.tax.raise.sdk.vo.recharge.TaxRaiseRechargeContractTemplateVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * 税筹充值合同模板client
 *
 * @author ning.zhang
 * @date 2022/3/22
 */
@Component
@Slf4j
public class TaxRaiseRechargeContractTemplateClient extends AbstractTaxRaiseClient {

  /**
   * 查询商户当前可签署充值合同模板信息
   *
   * @param dto 参数dto
   * @return 商户当前可签署充值合同模板信息
   */
  public TaxRaiseRechargeContractTemplateVo findByMerchantAccountDto(MerchantAccountDto dto) {
    Result result = super.doGet("/v1/external/contract/rechargeContractTemplate/findByMerchantAccountDto", dto, null);
    return JSON.parseObject(JSON.toJSONString(result.getResult()), TaxRaiseRechargeContractTemplateVo.class);
  }
}
