package com.biz.crm.cps.external.tax.raise.local.client.withdrawal;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.common.local.model.Result;
import com.biz.crm.cps.external.tax.raise.local.client.base.AbstractTaxRaiseClient;
import com.biz.crm.cps.external.tax.raise.sdk.dto.base.MerchantAccountBatchDto;
import com.biz.crm.cps.external.tax.raise.sdk.dto.base.MerchantAccountDto;
import com.biz.crm.cps.external.tax.raise.sdk.dto.base.TaxRaiseCustomerDto;
import com.biz.crm.cps.external.tax.raise.sdk.dto.withdrawal.TaxRaiseWithdrawalAccountDto;
import com.biz.crm.cps.external.tax.raise.sdk.dto.withdrawal.TaxRaiseWithdrawalAccountPageDto;
import com.biz.crm.cps.external.tax.raise.sdk.vo.withdrawal.TaxRaiseWithdrawalAccountVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 税筹提现账号信息client
 *
 * @author ning.zhang
 * @date 2022/3/22
 */
@Component
@Slf4j
public class TaxRaiseWithdrawalAccountClient extends AbstractTaxRaiseClient {

  /**
   * 通过商户账号信息获取提现账号信息
   *
   * @param dto 请求参数dto
   * @return 提现账号信息
   */
  public TaxRaiseWithdrawalAccountVo findByMerchantAccountDto(MerchantAccountDto dto) {
    Result result = super.doGet("/v1/external/contract/withdrawalAccount/findByMerchantAccountDto", dto, null);
    return JSON.parseObject(JSON.toJSONString(result.getResult()),TaxRaiseWithdrawalAccountVo.class);
  }

  /**
   * 通过商户账号信息批量获取提现账号信息
   *
   * @param dto 请求参数dto
   * @return 提现账号信息
   */
  public List<TaxRaiseWithdrawalAccountVo> findByMerchantAccountBatchDto(MerchantAccountBatchDto dto) {
    Result result = super.doGet("/v1/external/contract/withdrawalAccount/findByMerchantAccountBatchDto", dto, null);
    return JSON.parseArray(JSON.toJSONString(result.getResult()),TaxRaiseWithdrawalAccountVo.class);
  }

  /**
   * 提现实名认证账号信息分页列表
   *
   * @param dto      请求参数dto
   * @param pageable 分页信息
   * @return Page<FadadaWithdrawalAccountReportVo> 提现实名认证账号信息分页列表
   */
  public Page<TaxRaiseWithdrawalAccountVo> findByConditions(Pageable pageable, TaxRaiseWithdrawalAccountPageDto dto) {
    Result result = super.doGet("/v1/external/contract/withdrawalAccount/findByConditions", dto, pageable);
    return JSON.parseObject(JSON.toJSONString(result.getResult()),Page.class);
  }

  /**
   * 创建提现账号信息
   *
   * @param dto 请求参数dto
   * @return 提现账号信息
   */
  public TaxRaiseWithdrawalAccountVo create(TaxRaiseWithdrawalAccountDto dto) {
    Result result = super.doPost("/v1/external/contract/withdrawalAccount/create", dto);
    return JSON.parseObject(JSON.toJSONString(result.getResult()),TaxRaiseWithdrawalAccountVo.class);
  }

  /**
   * 身份证批量下载zip
   *
   * @param dto 参数dto
   * @return 下载结果
   */
  public String downloadIdentification(TaxRaiseCustomerDto dto) {
    Result result = super.doGet("/v1/external/contract/withdrawalAccount/downloadIdentification", dto, null);
    return String.valueOf(result.getResult());
  }

  /**
   * 营业执照批量下载zip
   *
   * @param dto 参数dto
   * @return 下载结果
   */
  public String downloadBusinessLicense(TaxRaiseCustomerDto dto) {
    Result result = super.doGet("/v1/external/contract/withdrawalAccount/downloadBusinessLicense", dto, null);
    return String.valueOf(result.getResult());
  }
}
