package com.biz.crm.cps.external.tax.raise.local.client.withdrawal;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.common.local.model.Result;
import com.biz.crm.cps.external.tax.raise.local.client.base.AbstractTaxRaiseClient;
import com.biz.crm.cps.external.tax.raise.sdk.dto.base.TaxRaiseContractDto;
import com.biz.crm.cps.external.tax.raise.sdk.dto.withdrawal.TaxRaiseWithdrawalContractPageDto;
import com.biz.crm.cps.external.tax.raise.sdk.vo.withdrawal.TaxRaiseWithdrawalContractVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

/**
 * 税筹提现合同client
 *
 * @author ning.zhang
 * @date 2022/3/22
 */
@Component
@Slf4j
public class TaxRaiseWithdrawalContractClient extends AbstractTaxRaiseClient {

  /**
   * 提现合同信息分页列表
   *
   * @param dto      请求参数dto
   * @param pageable 分页信息
   * @return Page<TaxRaiseWithdrawalContractVo> 提现合同信息分页列表
   */
  public Page<TaxRaiseWithdrawalContractVo> findByConditions(Pageable pageable, TaxRaiseWithdrawalContractPageDto dto) {
    Result result = super.doGet("/v1/external/contract/withdrawalContract/findByConditions", dto, pageable);
    return JSON.parseObject(JSON.toJSONString(result.getResult()),Page.class);
  }

  /**
   * 合同批量下载zip
   *
   * @param dto 参数dto
   * @return 下载结果
   */
  public String downloadContract(TaxRaiseContractDto dto) {
    Result result = super.doGet("/v1/external/contract/withdrawalContract/downloadContract", dto, null);
    return String.valueOf(result.getResult());
  }
}
