package com.biz.crm.cps.external.tax.raise.local.client.withdrawal;

import com.alibaba.fastjson.JSON;
import com.biz.crm.cps.business.common.local.model.Result;
import com.biz.crm.cps.external.tax.raise.local.client.base.AbstractTaxRaiseClient;
import com.biz.crm.cps.external.tax.raise.sdk.dto.withdrawal.TaxRaiseWithdrawalContractSignDto;
import com.biz.crm.cps.external.tax.raise.sdk.vo.withdrawal.TaxRaiseWithdrawalContractSignVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * 税筹提现合同签署client
 *
 * @author ning.zhang
 * @date 2022/3/22
 */
@Component
@Slf4j
public class TaxRaiseWithdrawalContractSignClient extends AbstractTaxRaiseClient {

  /**
   * 获取账号提现合同签署信息
   *
   * @param dto 参数dto
   * @return 账号提现合同签署信息
   */
  public TaxRaiseWithdrawalContractSignVo findByTaxRaiseWithdrawalContractSignDto(TaxRaiseWithdrawalContractSignDto dto) {
    Result result = super.doGet("/v1/external/contract/withdrawalContractSign/findByTaxRaiseWithdrawalContractSignDto", dto, null);
    return JSON.parseObject(JSON.toJSONString(result.getResult()), TaxRaiseWithdrawalContractSignVo.class);
  }

  /**
   * 提现合同签署
   *
   * @param dto 参数dto
   * @return 提现合同签署信息
   */
  public TaxRaiseWithdrawalContractSignVo create(TaxRaiseWithdrawalContractSignDto dto) {
    Result result = super.doPost("/v1/external/contract/withdrawalContractSign/create", dto);
    return JSON.parseObject(JSON.toJSONString(result.getResult()), TaxRaiseWithdrawalContractSignVo.class);
  }
}
