package com.biz.crm.cps.external.tax.raise.local.client.withdrawal;

import com.alibaba.fastjson.JSON;
import com.biz.crm.cps.business.common.local.model.Result;
import com.biz.crm.cps.external.tax.raise.local.client.base.AbstractTaxRaiseClient;
import com.biz.crm.cps.external.tax.raise.sdk.dto.base.MerchantAccountDto;
import com.biz.crm.cps.external.tax.raise.sdk.vo.withdrawal.TaxRaiseWithdrawalContractTemplateVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * 税筹提现合同模板client
 *
 * @author ning.zhang
 * @date 2022/3/22
 */
@Component
@Slf4j
public class TaxRaiseWithdrawalContractTemplateClient extends AbstractTaxRaiseClient {

  /**
   * 查询商户当前可签署提现合同模板信息
   *
   * @param dto 参数dto
   * @return 商户当前可签署提现合同模板信息
   */
  public TaxRaiseWithdrawalContractTemplateVo findByMerchantAccountDto(MerchantAccountDto dto) {
    Result result = super.doGet("/v1/external/contract/withdrawalContractTemplate/findByMerchantAccountDto", dto, null);
    return JSON.parseObject(JSON.toJSONString(result.getResult()), TaxRaiseWithdrawalContractTemplateVo.class);
  }
}
