package com.biz.crm.cps.external.tax.raise.local.config;

import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

/**
 * 税筹平台配置信息
 *
 * @author ning.zhang
 * @date 2022/3/18
 */
@Configuration
@ConfigurationProperties(prefix = "tax.raise")
@Setter
@Getter
public class TaxRaiseProperties {

  /**
   * 商户id
   */
  private String merchantId;

  /**
   * 商户秘钥
   */
  private String merchantSecret;

  /**
   * 税筹访问host地址
   */
  private String host;

  /**
   * 税筹充值回调cps地址
   */
  private String capitalRechargeReturnUrl;

  /**
   * 品牌商默认账号
   */
  private String brandDefaultAccount;
}
