package com.biz.crm.cps.external.tax.raise.local.controller.capital;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.common.local.model.Result;
import com.biz.crm.cps.external.tax.raise.sdk.dto.capital.TaxRaiseCapitalAccountTransactionQueryDto;
import com.biz.crm.cps.external.tax.raise.sdk.service.capital.TaxRaiseCapitalAccountTransactionVoService;
import com.biz.crm.cps.external.tax.raise.sdk.vo.capital.TaxRaiseCapitalAccountTransactionVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 税筹接口管理: TaxRaiseCapitalAccountTransactionDetailVo: 充值账户资金交易明细管理
 * @Author: wjx
 * @Date: 2022/3/23 15:40
 */
@Slf4j
@RestController
@RequestMapping("/v1/taxRaise/capital/accountTransaction")
@Api(tags = "税筹接口管理: TaxRaiseCapitalAccountTransactionVo: 充值账户资金交易明细管理")
public class TaxRaiseCapitalAccountTransactionVoController {

  @Autowired
  private TaxRaiseCapitalAccountTransactionVoService taxRaiseCapitalAccountTransactionVoService;

  @ApiOperation(value = "账户资金收支明细分页列表")
  @GetMapping("/findByConditions")
  public Result<Page<TaxRaiseCapitalAccountTransactionVo>> findByConditions(@PageableDefault(50) Pageable pageable,
                                                                            @ApiParam(name = "TaxRaiseCapitalAccountTransactionQueryDto", value = "参数dto") TaxRaiseCapitalAccountTransactionQueryDto dto) {
    try {
      return Result.ok(this.taxRaiseCapitalAccountTransactionVoService.findByConditions(pageable,dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "分页查询当前用户账户收支明细")
  @GetMapping("/findCurrentUserByConditions")
  public Result<Page<TaxRaiseCapitalAccountTransactionVo>> findCurrentUserByConditions(@PageableDefault(50) Pageable pageable,
                                                                            @ApiParam(name = "TaxRaiseCapitalAccountTransactionQueryDto", value = "参数dto") TaxRaiseCapitalAccountTransactionQueryDto dto) {
    try {
      return Result.ok(this.taxRaiseCapitalAccountTransactionVoService.findCurrentUserByConditions(pageable,dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
