package com.biz.crm.cps.external.tax.raise.local.controller.capital;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.common.local.model.Result;
import com.biz.crm.cps.external.tax.raise.sdk.dto.capital.TaxDeductionAmountDto;
import com.biz.crm.cps.external.tax.raise.sdk.dto.capital.TaxRaiseCapitalAccountQueryDto;
import com.biz.crm.cps.external.tax.raise.sdk.service.capital.TaxRaiseCapitalAccountVoService;
import com.biz.crm.cps.external.tax.raise.sdk.vo.capital.TaxRaiseCapitalAccountVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 税筹接口管理: TaxRaiseRechargeVo: 资金账户管理
 * @Author: wjx
 * @Date: 2022/3/23 15:40
 */
@Slf4j
@RestController
@RequestMapping("/v1/taxRaise/capital/account")
@Api(tags = "税筹接口管理: TaxRaiseCapitalAccountVo: 资金账户管理")
public class TaxRaiseCapitalAccountVoController {

  @Autowired
  private TaxRaiseCapitalAccountVoService taxRaiseCapitalAccountVoService;

  @ApiOperation(value = "账户资金信息分页列表")
  @GetMapping("/findByConditions")
  public Result<Page<TaxRaiseCapitalAccountVo>> findByConditions(@PageableDefault(50) Pageable pageable,
                                                                 @ApiParam(name = "TaxRaiseCapitalAccountQueryDto", value = "参数dto") TaxRaiseCapitalAccountQueryDto dto) {
    try {
      return Result.ok(this.taxRaiseCapitalAccountVoService.findByConditions(pageable,dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "查询当前用户账户资金信息")
  @GetMapping("/findByCurrentUser")
  public Result<TaxRaiseCapitalAccountVo> findByCurrentUser() {
    try {
      return Result.ok(this.taxRaiseCapitalAccountVoService.findByCurrentUser());
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "扣减账户资金")
  @PostMapping("/deductAmountByDeductionAmountDto")
  public Result<?> deductAmountByDeductionAmountDto(@RequestBody TaxDeductionAmountDto dto) {
    try {
      this.taxRaiseCapitalAccountVoService.deductAmountByDeductionAmountDto(dto);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
