package com.biz.crm.cps.external.tax.raise.local.controller.capital;

import com.biz.crm.cps.business.common.local.model.Result;
import com.biz.crm.cps.external.tax.raise.sdk.service.capital.TaxRaiseMerchantRechargeInfoVoService;
import com.biz.crm.cps.external.tax.raise.sdk.vo.capital.TaxRaiseMerchantRechargeInfoVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 税筹接口管理: TaxRaiseMerchantRechargeInfoVo: 商户平台充值信息管理
 * @Author: wjx
 * @Date: 2022/3/23 15:40
 */
@Slf4j
@RestController
@RequestMapping("/v1/taxRaise/capital/merchantRechargeInfo")
@Api(tags = "税筹接口管理: TaxRaiseMerchantRechargeInfoVo: 商户平台充值信息管理")
public class TaxRaiseMerchantRechargeInfoVoController {

  @Autowired
  private TaxRaiseMerchantRechargeInfoVoService taxRaiseMerchantRechargeInfoVoService;

  @ApiOperation(value = "查询当前商户平台充值信息")
  @GetMapping("/findByCurrentMerchant")
  public Result<TaxRaiseMerchantRechargeInfoVo> findByCurrentMerchant() {
    try {
      return Result.ok(this.taxRaiseMerchantRechargeInfoVoService.findByCurrentMerchant());
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "查询当前商户平台充值信息")
  @GetMapping("/findByMerchantRechargeCode")
  public Result<TaxRaiseMerchantRechargeInfoVo> findByMerchantRechargeCode(@RequestParam("merchantRechargeCode") String merchantRechargeCode) {
    try {
      return Result.ok(this.taxRaiseMerchantRechargeInfoVoService.findByMerchantRechargeCode(merchantRechargeCode));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
