package com.biz.crm.cps.external.tax.raise.local.controller.capital;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.common.local.model.Result;
import com.biz.crm.cps.external.tax.raise.sdk.dto.capital.TaxRaiseRechargeDto;
import com.biz.crm.cps.external.tax.raise.sdk.dto.capital.TaxRaiseRechargeQueryDto;
import com.biz.crm.cps.external.tax.raise.sdk.service.capital.TaxRaiseRechargeVoService;
import com.biz.crm.cps.external.tax.raise.sdk.vo.capital.TaxRaiseRechargeVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 税筹接口管理: TaxRaiseRechargeVo: 充值管理
 * @Author: wjx
 * @Date: 2022/3/23 15:40
 */
@Slf4j
@RestController
@RequestMapping("/v1/taxRaise/recharge/recharge")
@Api(tags = "税筹接口管理: TaxRaiseRechargeVo: 充值管理")
public class TaxRaiseRechargeVoController {

  @Autowired
  private TaxRaiseRechargeVoService taxRaiseRechargeVoService;

  @ApiOperation(value = "创建充值信息")
  @PostMapping("/create")
  public Result<TaxRaiseRechargeVo> create(@RequestBody TaxRaiseRechargeDto dto) {
    try {
      return Result.ok(this.taxRaiseRechargeVoService.create(dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "根据充值编号手动推送充值信息")
  @PostMapping("/pushByRechargeCode")
  public Result<TaxRaiseRechargeVo> pushByRechargeCode(@RequestParam("rechargeCode") String rechargeCode) {
    try {
      return Result.ok(this.taxRaiseRechargeVoService.pushByRechargeCode(rechargeCode));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "充值信息分页列表")
  @GetMapping("/findByConditions")
  public Result<Page<TaxRaiseRechargeVo>> findByConditions(@PageableDefault(50) Pageable pageable,
                                                                 @ApiParam(name = "TaxRaiseRechargeQueryDto", value = "参数dto") TaxRaiseRechargeQueryDto dto) {
    try {
      return Result.ok(this.taxRaiseRechargeVoService.findByConditions(pageable,dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

}
