package com.biz.crm.cps.external.tax.raise.local.controller.recharge;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.cps.external.tax.raise.sdk.dto.base.MerchantAccountBatchDto;
import com.biz.crm.cps.external.tax.raise.sdk.dto.base.MerchantAccountDto;
import com.biz.crm.cps.external.tax.raise.sdk.dto.base.TaxRaiseCustomerDto;
import com.biz.crm.cps.external.tax.raise.sdk.dto.recharge.TaxRaiseRechargeAccountDto;
import com.biz.crm.cps.external.tax.raise.sdk.dto.recharge.TaxRaiseRechargeAccountPageDto;
import com.biz.crm.cps.external.tax.raise.sdk.service.recharge.TaxRaiseRechargeAccountVoService;
import com.biz.crm.cps.external.tax.raise.sdk.vo.recharge.TaxRaiseRechargeAccountVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 税筹接口管理: TaxRaiseRechargeAccountVo: 充值账号管理
 *
 * @author ning.zhang
 * @date 2022/3/21
 */
@Slf4j
@RestController
@RequestMapping("/v1/taxRaise/account/rechargeAccount")
@Api(tags = "税筹接口管理: TaxRaiseRechargeAccountVo: 充值账号管理")
public class TaxRaiseRechargeAccountVoController {

  @Autowired
  private TaxRaiseRechargeAccountVoService taxRaiseRechargeAccountVoService;

  @ApiOperation(value = "充值实名认证账号信息分页列表")
  @GetMapping("/findByConditions")
  public Result<Page<TaxRaiseRechargeAccountVo>> findByConditions(@PageableDefault(50) Pageable pageable,
                                                                  @ApiParam(name = "TaxRaiseRechargeAccountPageDto", value = "参数dto") TaxRaiseRechargeAccountPageDto dto) {
    try {
      return Result.ok(this.taxRaiseRechargeAccountVoService.findByConditions(pageable, dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "创建充值账号信息")
  @PostMapping("/create")
  public Result<TaxRaiseRechargeAccountVo> create(@RequestBody TaxRaiseRechargeAccountDto dto) {
    try {
      return Result.ok(this.taxRaiseRechargeAccountVoService.create(dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "品牌商创建充值账号信息")
  @PostMapping("/createByBrandBusiness")
  public Result<TaxRaiseRechargeAccountVo> createByBrandBusiness() {
    try {
      return Result.ok(this.taxRaiseRechargeAccountVoService.createByBrandBusiness());
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "通过商户账号信息获取充值账号信息")
  @GetMapping("/findByMerchantAccountDto")
  public Result<TaxRaiseRechargeAccountVo> findByMerchantAccountDto(@ApiParam(name = "MerchantAccountDto", value = "参数dto") MerchantAccountDto dto) {
    try {
      return Result.ok(this.taxRaiseRechargeAccountVoService.findByMerchantAccountDto(dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "通过当前登录信息获取充值账号信息")
  @GetMapping("/findCurrentByMerchantAccountDto")
  public Result<TaxRaiseRechargeAccountVo> findCurrentByMerchantAccountDto() {
    try {
      return Result.ok(this.taxRaiseRechargeAccountVoService.findCurrentByMerchantAccountDto());
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "通过商户账号信息批量获取充值账号信息")
  @GetMapping("/findByMerchantAccountBatchDto")
  public Result<List<TaxRaiseRechargeAccountVo>> findByMerchantAccountBatchDto(@ApiParam(name = "MerchantAccountBatchDto", value = "参数dto") MerchantAccountBatchDto dto) {
    try {
      return Result.ok(this.taxRaiseRechargeAccountVoService.findByMerchantAccountBatchDto(dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 身份证下载zip
   *
   * @param customerIds 税筹用户认证编码
   * @return 下载结果
   */
  @GetMapping("/downloadIdentification")
  @ApiOperation("身份证下载zip地址")
  public Result<String> downloadIdentification(@RequestParam("customerIds") List<String> customerIds) {
    try {
      TaxRaiseCustomerDto dto = new TaxRaiseCustomerDto();
      dto.setCustomerIds(customerIds);
      Result<String> result = new Result<>();
      result.setResult(this.taxRaiseRechargeAccountVoService.downloadIdentification(dto));
      return result;
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 营业执照批量下载zip
   *
   * @param customerIds 税筹用户认证编码
   * @return 下载结果
   */
  @GetMapping("/downloadBusinessLicense")
  @ApiOperation("营业执照批量下载zip")
  public Result<String> downloadBusinessLicense(@RequestParam("customerIds") List<String> customerIds) {
    try {
      TaxRaiseCustomerDto dto = new TaxRaiseCustomerDto();
      dto.setCustomerIds(customerIds);
      Result<String> result = new Result<>();
      result.setResult(this.taxRaiseRechargeAccountVoService.downloadBusinessLicense(dto));
      return result;
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
