package com.biz.crm.cps.external.tax.raise.local.controller.recharge;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.cps.external.tax.raise.sdk.dto.recharge.TaxRaiseRechargeContractSignDto;
import com.biz.crm.cps.external.tax.raise.sdk.service.recharge.TaxRaiseRechargeContractSignVoService;
import com.biz.crm.cps.external.tax.raise.sdk.vo.recharge.TaxRaiseRechargeContractSignVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 税筹接口管理: TaxRaiseRechargeContractSignVo: 充值合同签署管理
 *
 * @author ning.zhang
 * @date 2022/3/21
 */
@Slf4j
@RestController
@RequestMapping("/v1/taxRaise/contract/rechargeContractSign")
@Api(tags = "税筹接口管理: TaxRaiseRechargeContractSignVo: 充值合同签署管理")
public class TaxRaiseRechargeContractSignVoController {

  @Autowired
  private TaxRaiseRechargeContractSignVoService taxRaiseRechargeContractSignVoService;

  @ApiOperation(value = "获取账号充值合同签署信息")
  @GetMapping("/findByTaxRaiseRechargeContractSignDto")
  public Result<TaxRaiseRechargeContractSignVo> findByConditions(@ApiParam(name = "TaxRaiseRechargeContractSignDto", value = "参数dto") TaxRaiseRechargeContractSignDto dto) {
    try {
      return Result.ok(this.taxRaiseRechargeContractSignVoService.findByTaxRaiseRechargeContractSignDto(dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "创建合同签署信息")
  @PostMapping("/create")
  public Result<TaxRaiseRechargeContractSignVo> create(@RequestBody TaxRaiseRechargeContractSignDto dto) {
    try {
      return Result.ok(this.taxRaiseRechargeContractSignVoService.create(dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "品牌商创建合同签署信息")
  @PostMapping("/createByBrandBusiness")
  public Result<TaxRaiseRechargeContractSignVo> createByBrandBusiness() {
    try {
      return Result.ok(this.taxRaiseRechargeContractSignVoService.createByBrandBusiness());
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

}
