package com.biz.crm.cps.external.tax.raise.local.controller.recharge;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.cps.external.tax.raise.sdk.dto.base.MerchantAccountDto;
import com.biz.crm.cps.external.tax.raise.sdk.service.recharge.TaxRaiseRechargeContractTemplateVoService;
import com.biz.crm.cps.external.tax.raise.sdk.vo.recharge.TaxRaiseRechargeContractTemplateVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 税筹接口管理: TaxRaiseRechargeContractSignVo: 充值合同签署管理
 *
 * @author ning.zhang
 * @date 2022/3/21
 */
@Slf4j
@RestController
@RequestMapping("/v1/taxRaise/contract/rechargeContractTemplate")
@Api(tags = "税筹接口管理: TaxRaiseRechargeContractTemplateVo: 充值合同模板管理")
public class TaxRaiseRechargeContractTemplateVoController {

  @Autowired
  private TaxRaiseRechargeContractTemplateVoService taxRaiseRechargeContractTemplateVoService;

  @ApiOperation(value = "获取账号充值合同签署信息")
  @GetMapping("/findByMerchantAccountDto")
  public Result<TaxRaiseRechargeContractTemplateVo> findByMerchantAccountDto(@ApiParam(name = "MerchantAccountDto", value = "参数dto") MerchantAccountDto dto) {
    try {
      return Result.ok(this.taxRaiseRechargeContractTemplateVoService.findByMerchantAccountDto(dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
