package com.biz.crm.cps.external.tax.raise.local.controller.recharge;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.cps.external.tax.raise.sdk.dto.base.TaxRaiseContractDto;
import com.biz.crm.cps.external.tax.raise.sdk.dto.recharge.TaxRaiseRechargeContractPageDto;
import com.biz.crm.cps.external.tax.raise.sdk.service.recharge.TaxRaiseRechargeContractVoService;
import com.biz.crm.cps.external.tax.raise.sdk.vo.recharge.TaxRaiseRechargeContractVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 税筹接口管理: TaxRaiseRechargeContractSignVo: 充值合同管理
 *
 * @author ning.zhang
 * @date 2022/3/21
 */
@Slf4j
@RestController
@RequestMapping("/v1/taxRaise/contract/rechargeContract")
@Api(tags = "税筹接口管理: TaxRaiseRechargeContractVo: 充值合同管理")
public class TaxRaiseRechargeContractVoController {

  @Autowired
  private TaxRaiseRechargeContractVoService taxRaiseRechargeContractVoService;

  @ApiOperation(value = "充值合同信息分页列表")
  @GetMapping("/findByConditions")
  public Result<Page<TaxRaiseRechargeContractVo>> findByConditions(@PageableDefault(50) Pageable pageable,
                                                                   @ApiParam(name = "TaxRaiseRechargeContractPageDto", value = "参数dto") TaxRaiseRechargeContractPageDto dto) {
    try {
      return Result.ok(this.taxRaiseRechargeContractVoService.findByConditions(pageable, dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 合同批量下载zip
   *
   * @param contractIds 合同编码集合
   * @return 下载结果
   */
  @GetMapping("/downloadContract")
  @ApiOperation("合同批量下载zip")
  public Result<String> downloadContract(@RequestParam("contractIds") List<String> contractIds) {
    try {
      TaxRaiseContractDto dto = new TaxRaiseContractDto();
      dto.setContractIds(contractIds);
      Result<String> result = new Result<>();
      result.setResult(this.taxRaiseRechargeContractVoService.downloadContract(dto));
      return result;
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
