package com.biz.crm.cps.external.tax.raise.local.controller.withdrawal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.cps.external.tax.raise.sdk.dto.base.MerchantAccountBatchDto;
import com.biz.crm.cps.external.tax.raise.sdk.dto.base.MerchantAccountDto;
import com.biz.crm.cps.external.tax.raise.sdk.dto.base.TaxRaiseCustomerDto;
import com.biz.crm.cps.external.tax.raise.sdk.dto.withdrawal.TaxRaiseWithdrawalAccountDto;
import com.biz.crm.cps.external.tax.raise.sdk.dto.withdrawal.TaxRaiseWithdrawalAccountPageDto;
import com.biz.crm.cps.external.tax.raise.sdk.service.withdrawal.TaxRaiseWithdrawalAccountVoService;
import com.biz.crm.cps.external.tax.raise.sdk.vo.withdrawal.TaxRaiseWithdrawalAccountVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 税筹接口管理: TaxRaiseWithdrawalAccountVo: 提现账号管理
 *
 * @author ning.zhang
 * @date 2022/3/21
 */
@Slf4j
@RestController
@RequestMapping("/v1/taxRaise/account/WithdrawalAccount")
@Api(tags = "税筹接口管理: TaxRaiseWithdrawalAccountVo: 提现账号管理")
public class TaxRaiseWithdrawalAccountVoController {

  @Autowired
  private TaxRaiseWithdrawalAccountVoService taxRaiseWithdrawalAccountVoService;

  @ApiOperation(value = "提现实名认证账号信息分页列表")
  @GetMapping("/findByConditions")
  public Result<Page<TaxRaiseWithdrawalAccountVo>> findByConditions(@PageableDefault(50) Pageable pageable,
                                                                  @ApiParam(name = "TaxRaiseWithdrawalAccountPageDto", value = "参数dto") TaxRaiseWithdrawalAccountPageDto dto) {
    try {
      return Result.ok(this.taxRaiseWithdrawalAccountVoService.findByConditions(pageable, dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "创建提现账号信息")
  @PostMapping("/create")
  public Result<TaxRaiseWithdrawalAccountVo> create(@RequestBody TaxRaiseWithdrawalAccountDto dto) {
    try {
      return Result.ok(this.taxRaiseWithdrawalAccountVoService.create(dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "通过商户账号信息获取提现账号信息")
  @GetMapping("/findByMerchantAccountDto")
  public Result<TaxRaiseWithdrawalAccountVo> findByMerchantAccountDto(@ApiParam(name = "MerchantAccountDto", value = "参数dto") MerchantAccountDto dto) {
    try {
      return Result.ok(this.taxRaiseWithdrawalAccountVoService.findByMerchantAccountDto(dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "通过商户账号信息获取提现账号信息")
  @GetMapping("/findByMerchantAccountBatchDto")
  public Result<List<TaxRaiseWithdrawalAccountVo>> findByMerchantAccountBatchDto(@ApiParam(name = "MerchantAccountBatchDto", value = "参数dto") MerchantAccountBatchDto dto) {
    try {
      return Result.ok(this.taxRaiseWithdrawalAccountVoService.findByMerchantAccountBatchDto(dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 身份证下载zip
   *
   * @param customerIds 税筹用户认证编码
   * @return 下载结果
   */
  @GetMapping("/downloadIdentification")
  @ApiOperation("身份证下载zip地址")
  public Result<String> downloadIdentification(@RequestParam("customerIds") List<String> customerIds) {
    try {
      TaxRaiseCustomerDto dto = new TaxRaiseCustomerDto();
      dto.setCustomerIds(customerIds);
      Result<String> result = new Result<>();
      result.setResult(this.taxRaiseWithdrawalAccountVoService.downloadIdentification(dto));
      return result;
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 营业执照批量下载zip
   *
   * @param customerIds 税筹用户认证编码
   * @return 下载结果
   */
  @GetMapping("/downloadBusinessLicense")
  @ApiOperation("营业执照批量下载zip")
  public Result<String> downloadBusinessLicense(@RequestParam("customerIds") List<String> customerIds) {
    try {
      TaxRaiseCustomerDto dto = new TaxRaiseCustomerDto();
      dto.setCustomerIds(customerIds);
      Result<String> result = new Result<>();
      result.setResult(this.taxRaiseWithdrawalAccountVoService.downloadBusinessLicense(dto));
      return result;
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
