package com.biz.crm.cps.external.tax.raise.local.controller.withdrawal;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.cps.external.tax.raise.sdk.dto.withdrawal.TaxRaiseWithdrawalContractSignDto;
import com.biz.crm.cps.external.tax.raise.sdk.service.withdrawal.TaxRaiseWithdrawalContractSignVoService;
import com.biz.crm.cps.external.tax.raise.sdk.vo.withdrawal.TaxRaiseWithdrawalContractSignVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 税筹接口管理: TaxRaiseWithdrawalContractSignVo: 提现合同签署管理
 *
 * @author ning.zhang
 * @date 2022/3/21
 */
@Slf4j
@RestController
@RequestMapping("/v1/taxRaise/contract/WithdrawalContractSign")
@Api(tags = "税筹接口管理: TaxRaiseWithdrawalContractSignVo: 提现合同签署管理")
public class TaxRaiseWithdrawalContractSignVoController {

  @Autowired
  private TaxRaiseWithdrawalContractSignVoService taxRaiseWithdrawalContractSignVoService;

  @ApiOperation(value = "获取账号提现合同签署信息")
  @GetMapping("/findByTaxRaiseWithdrawalContractSignDto")
  public Result<TaxRaiseWithdrawalContractSignVo> findByConditions(@ApiParam(name = "TaxRaiseWithdrawalContractSignDto", value = "参数dto") TaxRaiseWithdrawalContractSignDto dto) {
    try {
      return Result.ok(this.taxRaiseWithdrawalContractSignVoService.findByTaxRaiseWithdrawalContractSignDto(dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "创建合同签署信息")
  @PostMapping("/create")
  public Result<TaxRaiseWithdrawalContractSignVo> create(@RequestBody TaxRaiseWithdrawalContractSignDto dto) {
    try {
      return Result.ok(this.taxRaiseWithdrawalContractSignVoService.create(dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
