package com.biz.crm.cps.external.tax.raise.local.controller.withdrawal;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.cps.external.tax.raise.sdk.dto.base.MerchantAccountDto;
import com.biz.crm.cps.external.tax.raise.sdk.service.withdrawal.TaxRaiseWithdrawalContractTemplateVoService;
import com.biz.crm.cps.external.tax.raise.sdk.vo.withdrawal.TaxRaiseWithdrawalContractTemplateVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 税筹接口管理: TaxRaiseWithdrawalContractSignVo: 提现合同签署管理
 *
 * @author ning.zhang
 * @date 2022/3/21
 */
@Slf4j
@RestController
@RequestMapping("/v1/taxRaise/contract/WithdrawalContractTemplate")
@Api(tags = "税筹接口管理: TaxRaiseWithdrawalContractTemplateVo: 提现合同模板管理")
public class TaxRaiseWithdrawalContractTemplateVoController {

  @Autowired
  private TaxRaiseWithdrawalContractTemplateVoService taxRaiseWithdrawalContractTemplateVoService;

  @ApiOperation(value = "获取账号提现合同签署信息")
  @GetMapping("/findByMerchantAccountDto")
  public Result<TaxRaiseWithdrawalContractTemplateVo> findByMerchantAccountDto(@ApiParam(name = "MerchantAccountDto", value = "参数dto") MerchantAccountDto dto) {
    try {
      return Result.ok(this.taxRaiseWithdrawalContractTemplateVoService.findByMerchantAccountDto(dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
