package com.biz.crm.cps.external.tax.raise.local.service.capital.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.LoginUserDetailsForCPS;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.external.tax.raise.local.client.capital.TaxRaiseCapitalAccountTransactionClient;
import com.biz.crm.cps.external.tax.raise.sdk.dto.capital.TaxRaiseCapitalAccountTransactionQueryDto;
import com.biz.crm.cps.external.tax.raise.sdk.service.capital.TaxRaiseCapitalAccountTransactionVoService;
import com.biz.crm.cps.external.tax.raise.sdk.vo.capital.TaxRaiseCapitalAccountTransactionVo;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

/**
 * 税筹平台资金账户收支明细信息服务接口类
 * @Author: wjx
 * @Date: 2022/3/28 10:36
 */
@Service
@Slf4j
public class TaxRaiseCapitalAccountTransactionVoServiceImpl implements TaxRaiseCapitalAccountTransactionVoService {

  @Autowired
  private TaxRaiseCapitalAccountTransactionClient taxRaiseCapitalAccountTransactionClient;
  @Autowired
  private LoginUserService loginUserService;

  @Override
  public Page<TaxRaiseCapitalAccountTransactionVo> findByConditions(Pageable pageable, TaxRaiseCapitalAccountTransactionQueryDto dto) {
    if(dto == null ){
      return new Page<>();
    }
    //cps账户为税筹平台的商户平台用户账户
    dto.setMerchantUserAccount(dto.getAccountCode());
    dto.setAccountCode(null);
    return this.taxRaiseCapitalAccountTransactionClient.findByConditions(pageable, dto);
  }

  @Override
  public Page<TaxRaiseCapitalAccountTransactionVo> findCurrentUserByConditions(Pageable pageable, TaxRaiseCapitalAccountTransactionQueryDto dto) {
    //查询用户登录信息
    LoginUserDetailsForCPS loginDetails = loginUserService.getLoginDetails(LoginUserDetailsForCPS.class);
    Validate.notNull(loginDetails,"未获取到用户登录信息");
    dto.setMerchantUserAccount(loginDetails.getAccount());
    return this.taxRaiseCapitalAccountTransactionClient.findByConditions(pageable, dto);
  }
}
