package com.biz.crm.cps.external.tax.raise.local.service.capital.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.LoginUserDetailsForCPS;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.external.tax.raise.local.client.capital.TaxRaiseCapitalAccountClient;
import com.biz.crm.cps.external.tax.raise.sdk.dto.base.MerchantAccountDto;
import com.biz.crm.cps.external.tax.raise.sdk.dto.capital.TaxDeductionAmountDto;
import com.biz.crm.cps.external.tax.raise.sdk.dto.capital.TaxRaiseCapitalAccountQueryDto;
import com.biz.crm.cps.external.tax.raise.sdk.service.capital.TaxRaiseCapitalAccountVoService;
import com.biz.crm.cps.external.tax.raise.sdk.vo.capital.TaxRaiseCapitalAccountVo;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * 税筹平台资金账户信息服务接口类
 * @Author: wjx
 * @Date: 2022/3/23 17:09
 */
@Service
@Slf4j
public class TaxRaiseCapitalAccountVoServiceImpl implements TaxRaiseCapitalAccountVoService {

  @Autowired
  private TaxRaiseCapitalAccountClient taxRaiseCapitalAccountClient;
  @Autowired
  private LoginUserService loginUserService;

  @Override
  public Page<TaxRaiseCapitalAccountVo> findByConditions(Pageable pageable, TaxRaiseCapitalAccountQueryDto dto) {
    //cps账户为税筹平台的商户平台用户账户
    dto.setMerchantUserAccount(dto.getAccountCode());
    dto.setAccountCode(null);
    return this.taxRaiseCapitalAccountClient.findByConditions(pageable, dto);
  }

  @Override
  public TaxRaiseCapitalAccountVo findByCurrentUser() {
    //查询用户登录信息
    LoginUserDetailsForCPS loginDetails = loginUserService.getLoginDetails(LoginUserDetailsForCPS.class);
    Validate.notNull(loginDetails,"未获取到用户登录信息");
    MerchantAccountDto merchantAccountDto = new MerchantAccountDto();
    merchantAccountDto.setMerchantUserAccount(loginDetails.getAccount());
    return this.taxRaiseCapitalAccountClient.findByMerchantUserAccount(merchantAccountDto);
  }

  @Override
  @Transactional
  public void deductAmountByDeductionAmountDto(TaxDeductionAmountDto dto) {
    Validate.notNull(dto,"扣减账户资金时,请求参数不能为空");
    taxRaiseCapitalAccountClient.deductAmountByDeductionAmountDto(dto);
  }

  @Override
  public TaxRaiseCapitalAccountVo findByMerchantUserAccount(String merchantUserAccount) {
    if (StringUtils.isBlank(merchantUserAccount)){
      return new TaxRaiseCapitalAccountVo();
    }
    MerchantAccountDto merchantAccountDto = new MerchantAccountDto();
    merchantAccountDto.setMerchantUserAccount(merchantUserAccount);
    return this.taxRaiseCapitalAccountClient.findByMerchantUserAccount(merchantAccountDto);
  }
}
