package com.biz.crm.cps.external.tax.raise.local.service.capital.internal;

import com.biz.crm.cps.external.tax.raise.local.client.capital.TaxRaiseMerchantRechargeInfoClient;
import com.biz.crm.cps.external.tax.raise.sdk.dto.capital.TaxRaiseMerchantRechargeInfoDto;
import com.biz.crm.cps.external.tax.raise.sdk.service.capital.TaxRaiseMerchantRechargeInfoVoService;
import com.biz.crm.cps.external.tax.raise.sdk.vo.capital.TaxRaiseMerchantRechargeInfoVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 商户平台充值信息服务实现
 * @Author: wjx
 * @Date: 2022/3/30 21:44
 */
@Service
@Slf4j
public class TaxRaiseMerchantRechargeInfoVoServiceImpl implements TaxRaiseMerchantRechargeInfoVoService {

  @Autowired
  private TaxRaiseMerchantRechargeInfoClient taxRaiseMerchantRechargeInfoClient;

  @Override
  public TaxRaiseMerchantRechargeInfoVo findByCurrentMerchant() {
    return taxRaiseMerchantRechargeInfoClient.findByCurrentMerchant();
  }

  @Override
  public TaxRaiseMerchantRechargeInfoVo findByMerchantRechargeCode(String merchantRechargeCode) {
    TaxRaiseMerchantRechargeInfoDto dto = new TaxRaiseMerchantRechargeInfoDto();
    dto.setMerchantRechargeCode(merchantRechargeCode);
    return taxRaiseMerchantRechargeInfoClient.findByMerchantRechargeCode(dto);
  }
}
