package com.biz.crm.cps.external.tax.raise.local.service.capital.internal;

import com.biz.crm.cps.business.capital.sdk.common.enums.DataSourceEnum;
import com.biz.crm.cps.external.tax.raise.local.client.capital.TaxRaisePaymentClient;
import com.biz.crm.cps.external.tax.raise.local.config.TaxRaiseProperties;
import com.biz.crm.cps.external.tax.raise.sdk.dto.capital.TaxRaisePaymentBatchDto;
import com.biz.crm.cps.external.tax.raise.sdk.dto.capital.TaxRaisePaymentDto;
import com.biz.crm.cps.external.tax.raise.sdk.service.capital.TaxRaisePaymentVoService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 税筹平台付款vo信息服务接口类
 * @Author: wjx
 * @Date: 2022/3/23 15:29
 */
@Service
@Slf4j
public class TaxRaisePaymentVoServiceImpl implements TaxRaisePaymentVoService {

  @Autowired
  private TaxRaisePaymentClient taxRaisePaymentClient;
  @Autowired
  private TaxRaiseProperties properties;

  @Override
  public void pushPaymentBatch(List<TaxRaisePaymentDto> taxRaisePaymentDtos) {
    Validate.notEmpty(taxRaisePaymentDtos,"推送付款数据到税筹平台时,数据不能为空");
    for (TaxRaisePaymentDto taxRaisePaymentDto : taxRaisePaymentDtos) {
      taxRaisePaymentDto.setDataSource(DataSourceEnum.CPS_PUSH.getDictCode());
      //TODO 回调地址
    }
    TaxRaisePaymentBatchDto taxRaisePaymentBatchDto = new TaxRaisePaymentBatchDto();
    taxRaisePaymentBatchDto.setTaxRaisePaymentDtos(taxRaisePaymentDtos);
    this.taxRaisePaymentClient.createBatch(taxRaisePaymentBatchDto);
  }
}
