package com.biz.crm.cps.external.tax.raise.local.service.capital.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.LoginUserDetailsForCPS;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.business.capital.sdk.common.enums.DataSourceEnum;
import com.biz.crm.cps.business.capital.sdk.service.CapitalRechargeVoService;
import com.biz.crm.cps.business.capital.sdk.vo.CapitalRechargeVo;
import com.biz.crm.cps.external.tax.raise.local.client.capital.TaxRaiseRechargeClient;
import com.biz.crm.cps.external.tax.raise.local.config.TaxRaiseProperties;
import com.biz.crm.cps.external.tax.raise.sdk.dto.capital.TaxRaiseRechargeBatchDto;
import com.biz.crm.cps.external.tax.raise.sdk.dto.capital.TaxRaiseRechargeDto;
import com.biz.crm.cps.external.tax.raise.sdk.dto.capital.TaxRaiseRechargeQueryDto;
import com.biz.crm.cps.external.tax.raise.sdk.service.capital.TaxRaiseRechargeVoService;
import com.biz.crm.cps.external.tax.raise.sdk.vo.capital.TaxRaiseRechargeVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 税筹平台充值vo信息服务接口类
 * @Author: wjx
 * @Date: 2022/3/23 15:29
 */
@Service
@Slf4j
public class TaxRaiseRechargeVoServiceImpl implements TaxRaiseRechargeVoService {

  @Autowired
  private TaxRaiseRechargeClient taxRaiseRechargeClient;
  @Autowired
  private CapitalRechargeVoService capitalRechargeVoService;
  @Autowired
  private NebulaToolkitService nebulaToolkitService;
  @Autowired
  private LoginUserService loginUserService;
  @Autowired
  private TaxRaiseProperties properties;

  @Override
  @Transactional
  public TaxRaiseRechargeVo create(TaxRaiseRechargeDto dto) {
    return this.taxRaiseRechargeClient.create(dto);
  }

  @Override
  @Transactional
  public TaxRaiseRechargeVo pushByRechargeCode(String rechargeCode) {
    Validate.notBlank(rechargeCode,"根据充值编号手动推送充值信息时,充值信息不能为空");
    CapitalRechargeVo capitalRechargeVo = capitalRechargeVoService.findByRechargeCode(rechargeCode);
    Validate.notBlank(rechargeCode,"根据充值编号手动推送充值信息时,未查询到充值信息");
    TaxRaiseRechargeDto taxRaiseRechargeDto = nebulaToolkitService.copyObjectByBlankList(capitalRechargeVo, TaxRaiseRechargeDto.class, LinkedHashSet.class, ArrayList.class);
    taxRaiseRechargeDto.setDataSource(DataSourceEnum.CPS_PUSH.getDictCode());
    TaxRaiseRechargeVo taxRaiseRechargeVo = this.taxRaiseRechargeClient.create(taxRaiseRechargeDto);
    //更改推送状态
    this.capitalRechargeVoService.updatePushStatusByRechargeCodes(Arrays.asList(rechargeCode));
    return taxRaiseRechargeVo;
  }

  @Override
  public Page<TaxRaiseRechargeVo> findByConditions(Pageable pageable, TaxRaiseRechargeQueryDto dto) {
    //查询用户登录信息
    LoginUserDetailsForCPS loginDetails = loginUserService.getLoginDetails(LoginUserDetailsForCPS.class);
    Validate.notNull(loginDetails,"未获取到用户登录信息");
    dto.setMerchantUserAccount(loginDetails.getAccount());
    return this.taxRaiseRechargeClient.findByConditions(pageable, dto);
  }

  @Override
  public void pushRechargeBatch(List<TaxRaiseRechargeDto> taxRaiseRechargeDtos) {
    Validate.notEmpty(taxRaiseRechargeDtos,"推送充值数据到税筹平台时,数据不能为空");
    for (TaxRaiseRechargeDto taxRaiseRechargeDto : taxRaiseRechargeDtos) {
      taxRaiseRechargeDto.setDataSource(DataSourceEnum.CPS_PUSH.getDictCode());
      taxRaiseRechargeDto.setReturnUrl(properties.getCapitalRechargeReturnUrl());
    }
    TaxRaiseRechargeBatchDto taxRaiseRechargeBatchDto = new TaxRaiseRechargeBatchDto();
    taxRaiseRechargeBatchDto.setTaxRaiseRechargeDtos(taxRaiseRechargeDtos);
    this.taxRaiseRechargeClient.createBatch(taxRaiseRechargeBatchDto);
    //更改推送状态
    List<String> rechargeCodes = taxRaiseRechargeDtos.stream().map(TaxRaiseRechargeDto::getRechargeCode).collect(Collectors.toList());
    this.capitalRechargeVoService.updatePushStatusByRechargeCodes(rechargeCodes);
  }
}
