package com.biz.crm.cps.external.tax.raise.local.service.recharge.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.LoginUserDetailsForCPS;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.external.tax.raise.local.client.recharge.TaxRaiseRechargeAccountClient;
import com.biz.crm.cps.external.tax.raise.local.config.TaxRaiseProperties;
import com.biz.crm.cps.external.tax.raise.sdk.dto.base.MerchantAccountBatchDto;
import com.biz.crm.cps.external.tax.raise.sdk.dto.base.MerchantAccountDto;
import com.biz.crm.cps.external.tax.raise.sdk.dto.base.TaxRaiseCustomerDto;
import com.biz.crm.cps.external.tax.raise.sdk.dto.recharge.TaxRaiseRechargeAccountDto;
import com.biz.crm.cps.external.tax.raise.sdk.dto.recharge.TaxRaiseRechargeAccountPageDto;
import com.biz.crm.cps.external.tax.raise.sdk.enums.recharge.TaxRaiseRechargeAccountTypeEnum;
import com.biz.crm.cps.external.tax.raise.sdk.service.recharge.TaxRaiseRechargeAccountVoService;
import com.biz.crm.cps.external.tax.raise.sdk.vo.recharge.TaxRaiseRechargeAccountVo;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 税筹平台充值账户信息Vo服务接口实现类
 *
 * @author ning.zhang
 * @date 2022/3/21
 */
@Service
@Slf4j
public class TaxRaiseRechargeAccountVoServiceImpl implements TaxRaiseRechargeAccountVoService {

  @Autowired
  private TaxRaiseRechargeAccountClient taxRaiseRechargeAccountClient;
  @Autowired
  private LoginUserService loginUserService;
  @Autowired
  private TaxRaiseProperties properties;

  @Override
  public TaxRaiseRechargeAccountVo findByMerchantAccountDto(MerchantAccountDto dto) {
    return this.taxRaiseRechargeAccountClient.findByMerchantAccountDto(dto);
  }

  @Override
  public TaxRaiseRechargeAccountVo findCurrentByMerchantAccountDto() {
    MerchantAccountDto dto = new MerchantAccountDto();
    //查询当前登录对象
    LoginUserDetailsForCPS loginUser = loginUserService.getLoginDetails(LoginUserDetailsForCPS.class);
    Validate.notNull(loginUser, "未查询到当前登录信息");
    dto.setMerchantUserAccount(loginUser.getAccount());
    return this.taxRaiseRechargeAccountClient.findByMerchantAccountDto(dto);
  }

  @Override
  public List<TaxRaiseRechargeAccountVo> findByMerchantAccountBatchDto(MerchantAccountBatchDto dto) {
    return this.taxRaiseRechargeAccountClient.findByMerchantAccountBatchDto(dto);
  }

  @Override
  public Page<TaxRaiseRechargeAccountVo> findByConditions(Pageable pageable, TaxRaiseRechargeAccountPageDto dto) {
    return this.taxRaiseRechargeAccountClient.findByConditions(pageable, dto);
  }

  @Override
  public TaxRaiseRechargeAccountVo create(TaxRaiseRechargeAccountDto dto) {
    return this.taxRaiseRechargeAccountClient.create(dto);
  }

  @Override
  public TaxRaiseRechargeAccountVo createByBrandBusiness() {
    TaxRaiseRechargeAccountDto dto = new TaxRaiseRechargeAccountDto();
    dto.setAccountType(TaxRaiseRechargeAccountTypeEnum.COMPANY.getDictCode());
    dto.setMerchantUserAccount(properties.getBrandDefaultAccount());
    this.taxRaiseRechargeAccountClient.create(dto);
    return this.taxRaiseRechargeAccountClient.findByMerchantAccountDto(dto);
  }

  @Override
  public String downloadIdentification(TaxRaiseCustomerDto dto) {
    return this.taxRaiseRechargeAccountClient.downloadIdentification(dto);
  }

  @Override
  public String downloadBusinessLicense(TaxRaiseCustomerDto dto) {
    return this.taxRaiseRechargeAccountClient.downloadBusinessLicense(dto);
  }
}
