package com.biz.crm.cps.external.tax.raise.local.service.recharge.internal;

import com.biz.crm.cps.external.tax.raise.local.client.recharge.TaxRaiseRechargeAccountClient;
import com.biz.crm.cps.external.tax.raise.local.client.recharge.TaxRaiseRechargeContractSignClient;
import com.biz.crm.cps.external.tax.raise.local.client.recharge.TaxRaiseRechargeContractTemplateClient;
import com.biz.crm.cps.external.tax.raise.local.config.TaxRaiseProperties;
import com.biz.crm.cps.external.tax.raise.sdk.dto.recharge.TaxRaiseRechargeContractSignDto;
import com.biz.crm.cps.external.tax.raise.sdk.enums.recharge.TaxRaiseRechargeAccountTypeEnum;
import com.biz.crm.cps.external.tax.raise.sdk.enums.recharge.TaxRaiseRechargeCompanyVerifyStatusEnum;
import com.biz.crm.cps.external.tax.raise.sdk.service.recharge.TaxRaiseRechargeContractSignVoService;
import com.biz.crm.cps.external.tax.raise.sdk.vo.recharge.TaxRaiseRechargeAccountVo;
import com.biz.crm.cps.external.tax.raise.sdk.vo.recharge.TaxRaiseRechargeContractSignVo;
import com.biz.crm.cps.external.tax.raise.sdk.vo.recharge.TaxRaiseRechargeContractTemplateVo;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Objects;

/**
 * 税筹充值合同签署vo服务接口实现类
 *
 * @author ning.zhang
 * @date 2022/3/21
 */
@Service
@Slf4j
public class TaxRaiseRechargeContractSignVoServiceImpl implements TaxRaiseRechargeContractSignVoService {

  @Autowired
  private TaxRaiseRechargeContractSignClient taxRaiseRechargeContractSignClient;
  @Autowired
  private TaxRaiseProperties properties;
  @Autowired
  private TaxRaiseRechargeAccountClient taxRaiseRechargeAccountClient;
  @Autowired
  private TaxRaiseRechargeContractTemplateClient taxRaiseRechargeContractTemplateClient;

  @Override
  public TaxRaiseRechargeContractSignVo findByTaxRaiseRechargeContractSignDto(TaxRaiseRechargeContractSignDto dto) {
    return this.taxRaiseRechargeContractSignClient.findByTaxRaiseRechargeContractSignDto(dto);
  }

  @Override
  public TaxRaiseRechargeContractSignVo create(TaxRaiseRechargeContractSignDto dto) {
    return this.taxRaiseRechargeContractSignClient.create(dto);
  }

  @Override
  public TaxRaiseRechargeContractSignVo createByBrandBusiness() {
    TaxRaiseRechargeContractSignDto dto = new TaxRaiseRechargeContractSignDto();
    dto.setMerchantUserAccount(properties.getBrandDefaultAccount());
    TaxRaiseRechargeAccountVo accountVo = this.taxRaiseRechargeAccountClient.findByMerchantAccountDto(dto);
    Validate.isTrue(Objects.nonNull(accountVo) && TaxRaiseRechargeCompanyVerifyStatusEnum.PASSED.getDictCode().equals(accountVo.getCompanyStatus())
        ,"还未通过企业实名认证,无法签署合同");
    TaxRaiseRechargeContractTemplateVo templateVo = this.taxRaiseRechargeContractTemplateClient.findByMerchantAccountDto(dto);
    Validate.notNull(templateVo, "未查询到合同模板！");
    dto.setTemplateCode(templateVo.getTemplateCode());
    TaxRaiseRechargeContractSignVo contractSignVo = taxRaiseRechargeContractSignClient.findByTaxRaiseRechargeContractSignDto(dto);
    if (Objects.isNull(contractSignVo)) {
      contractSignVo = this.taxRaiseRechargeContractSignClient.create(dto);
    }
    return contractSignVo;
  }
}
