package com.biz.crm.cps.external.tax.raise.local.service.recharge.internal;

import com.biz.crm.cps.external.tax.raise.local.client.recharge.TaxRaiseRechargeContractTemplateClient;
import com.biz.crm.cps.external.tax.raise.sdk.dto.base.MerchantAccountDto;
import com.biz.crm.cps.external.tax.raise.sdk.service.recharge.TaxRaiseRechargeContractTemplateVoService;
import com.biz.crm.cps.external.tax.raise.sdk.vo.recharge.TaxRaiseRechargeContractTemplateVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 税筹充值合同模板vo服务接口实现类
 *
 * @author ning.zhang
 * @date 2022/3/21
 */
@Service
@Slf4j
public class TaxRaiseRechargeContractTemplateVoServiceImpl implements TaxRaiseRechargeContractTemplateVoService {

  @Autowired
  private TaxRaiseRechargeContractTemplateClient taxRaiseRechargeContractTemplateClient;


  @Override
  public TaxRaiseRechargeContractTemplateVo findByMerchantAccountDto(MerchantAccountDto dto) {
    return this.taxRaiseRechargeContractTemplateClient.findByMerchantAccountDto(dto);
  }
}
