package com.biz.crm.cps.external.tax.raise.local.service.recharge.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.external.tax.raise.local.client.recharge.TaxRaiseRechargeContractClient;
import com.biz.crm.cps.external.tax.raise.sdk.dto.base.TaxRaiseContractDto;
import com.biz.crm.cps.external.tax.raise.sdk.dto.recharge.TaxRaiseRechargeContractPageDto;
import com.biz.crm.cps.external.tax.raise.sdk.service.recharge.TaxRaiseRechargeContractVoService;
import com.biz.crm.cps.external.tax.raise.sdk.vo.recharge.TaxRaiseRechargeContractVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

/**
 * 税筹充值合同VO服务接口实现类
 *
 * @author ning.zhang
 * @date 2022/3/21
 */
@Service
@Slf4j
public class TaxRaiseRechargeContractVoServiceImpl implements TaxRaiseRechargeContractVoService {

  @Autowired
  private TaxRaiseRechargeContractClient taxRaiseRechargeContractClient;


  @Override
  public Page<TaxRaiseRechargeContractVo> findByConditions(Pageable pageable, TaxRaiseRechargeContractPageDto dto) {
    return this.taxRaiseRechargeContractClient.findByConditions(pageable, dto);
  }

  @Override
  public String downloadContract(TaxRaiseContractDto dto) {
    return this.taxRaiseRechargeContractClient.downloadContract(dto);
  }
}
