package com.biz.crm.cps.external.tax.raise.local.service.withdrawal.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.external.tax.raise.local.client.withdrawal.TaxRaiseWithdrawalAccountClient;
import com.biz.crm.cps.external.tax.raise.sdk.dto.base.MerchantAccountBatchDto;
import com.biz.crm.cps.external.tax.raise.sdk.dto.base.MerchantAccountDto;
import com.biz.crm.cps.external.tax.raise.sdk.dto.base.TaxRaiseCustomerDto;
import com.biz.crm.cps.external.tax.raise.sdk.dto.withdrawal.TaxRaiseWithdrawalAccountDto;
import com.biz.crm.cps.external.tax.raise.sdk.dto.withdrawal.TaxRaiseWithdrawalAccountPageDto;
import com.biz.crm.cps.external.tax.raise.sdk.service.withdrawal.TaxRaiseWithdrawalAccountVoService;
import com.biz.crm.cps.external.tax.raise.sdk.vo.withdrawal.TaxRaiseWithdrawalAccountVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 税筹平台提现账户信息Vo服务接口实现类
 *
 * @author ning.zhang
 * @date 2022/3/21
 */
@Service
@Slf4j
public class TaxRaiseWithdrawalAccountVoServiceImpl implements TaxRaiseWithdrawalAccountVoService {

  @Autowired
  private TaxRaiseWithdrawalAccountClient taxRaiseWithdrawalAccountClient;

  @Override
  public TaxRaiseWithdrawalAccountVo findByMerchantAccountDto(MerchantAccountDto dto) {
    return this.taxRaiseWithdrawalAccountClient.findByMerchantAccountDto(dto);
  }

  @Override
  public List<TaxRaiseWithdrawalAccountVo> findByMerchantAccountBatchDto(MerchantAccountBatchDto dto) {
    return this.taxRaiseWithdrawalAccountClient.findByMerchantAccountBatchDto(dto);
  }

  @Override
  public Page<TaxRaiseWithdrawalAccountVo> findByConditions(Pageable pageable, TaxRaiseWithdrawalAccountPageDto dto) {
    return this.taxRaiseWithdrawalAccountClient.findByConditions(pageable, dto);
  }

  @Override
  public TaxRaiseWithdrawalAccountVo create(TaxRaiseWithdrawalAccountDto dto) {
    return this.taxRaiseWithdrawalAccountClient.create(dto);
  }

  @Override
  public String downloadIdentification(TaxRaiseCustomerDto dto) {
    return this.taxRaiseWithdrawalAccountClient.downloadIdentification(dto);
  }

  @Override
  public String downloadBusinessLicense(TaxRaiseCustomerDto dto) {
    return this.taxRaiseWithdrawalAccountClient.downloadBusinessLicense(dto);
  }
}
