package com.biz.crm.cps.external.tax.raise.local.service.withdrawal.internal;

import com.biz.crm.cps.external.tax.raise.local.client.withdrawal.TaxRaiseWithdrawalContractSignClient;
import com.biz.crm.cps.external.tax.raise.sdk.dto.withdrawal.TaxRaiseWithdrawalContractSignDto;
import com.biz.crm.cps.external.tax.raise.sdk.service.withdrawal.TaxRaiseWithdrawalContractSignVoService;
import com.biz.crm.cps.external.tax.raise.sdk.vo.withdrawal.TaxRaiseWithdrawalContractSignVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 税筹提现合同签署vo服务接口实现类
 *
 * @author ning.zhang
 * @date 2022/3/21
 */
@Service
@Slf4j
public class TaxRaiseWithdrawalContractSignVoServiceImpl implements TaxRaiseWithdrawalContractSignVoService {

  @Autowired
  private TaxRaiseWithdrawalContractSignClient taxRaiseWithdrawalContractSignClient;

  @Override
  public TaxRaiseWithdrawalContractSignVo findByTaxRaiseWithdrawalContractSignDto(TaxRaiseWithdrawalContractSignDto dto) {
    return this.taxRaiseWithdrawalContractSignClient.findByTaxRaiseWithdrawalContractSignDto(dto);
  }

  @Override
  public TaxRaiseWithdrawalContractSignVo create(TaxRaiseWithdrawalContractSignDto dto) {
    return this.taxRaiseWithdrawalContractSignClient.create(dto);
  }
}
