package com.biz.crm.cps.external.tax.raise.local.service.withdrawal.internal;

import com.biz.crm.cps.external.tax.raise.local.client.withdrawal.TaxRaiseWithdrawalContractTemplateClient;
import com.biz.crm.cps.external.tax.raise.sdk.dto.base.MerchantAccountDto;
import com.biz.crm.cps.external.tax.raise.sdk.service.withdrawal.TaxRaiseWithdrawalContractTemplateVoService;
import com.biz.crm.cps.external.tax.raise.sdk.vo.withdrawal.TaxRaiseWithdrawalContractTemplateVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 税筹提现合同模板vo服务接口实现类
 *
 * @author ning.zhang
 * @date 2022/3/21
 */
@Service
@Slf4j
public class TaxRaiseWithdrawalContractTemplateVoServiceImpl implements TaxRaiseWithdrawalContractTemplateVoService {

  @Autowired
  private TaxRaiseWithdrawalContractTemplateClient taxRaiseWithdrawalContractTemplateClient;


  @Override
  public TaxRaiseWithdrawalContractTemplateVo findByMerchantAccountDto(MerchantAccountDto dto) {
    return this.taxRaiseWithdrawalContractTemplateClient.findByMerchantAccountDto(dto);
  }
}
