package com.biz.crm.cps.external.tax.raise.local.service.withdrawal.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.external.tax.raise.local.client.withdrawal.TaxRaiseWithdrawalContractClient;
import com.biz.crm.cps.external.tax.raise.sdk.dto.base.TaxRaiseContractDto;
import com.biz.crm.cps.external.tax.raise.sdk.dto.withdrawal.TaxRaiseWithdrawalContractPageDto;
import com.biz.crm.cps.external.tax.raise.sdk.service.withdrawal.TaxRaiseWithdrawalContractVoService;
import com.biz.crm.cps.external.tax.raise.sdk.vo.withdrawal.TaxRaiseWithdrawalContractVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

/**
 * 税筹提现合同VO服务接口实现类
 *
 * @author ning.zhang
 * @date 2022/3/21
 */
@Service
@Slf4j
public class TaxRaiseWithdrawalContractVoServiceImpl implements TaxRaiseWithdrawalContractVoService {

  @Autowired
  private TaxRaiseWithdrawalContractClient taxRaiseWithdrawalContractClient;


  @Override
  public Page<TaxRaiseWithdrawalContractVo> findByConditions(Pageable pageable, TaxRaiseWithdrawalContractPageDto dto) {
    return this.taxRaiseWithdrawalContractClient.findByConditions(pageable, dto);
  }

  @Override
  public String downloadContract(TaxRaiseContractDto dto) {
    return this.taxRaiseWithdrawalContractClient.downloadContract(dto);
  }
}
