/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.external.tax.raise.local.client.base;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.biz.crm.cps.business.common.local.model.Result;
import com.biz.crm.cps.external.tax.raise.local.config.TaxRaiseProperties;
import com.biz.crm.cps.external.tax.raise.sdk.dto.base.BaseTaxRaiseDto;
import java.net.URI;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public abstract class AbstractTaxRaiseClient {
    private static final Logger log = LoggerFactory.getLogger(AbstractTaxRaiseClient.class);
    @Autowired
    protected TaxRaiseProperties properties;
    @Autowired
    private RestTemplate restTemplate;

    protected <T extends BaseTaxRaiseDto> Result doGet(String url, T paramObject, Pageable pageable) {
        Result result;
        try {
            UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)String.format("%s/%s", this.properties.getHost(), url));
            JSONObject paramJson = new JSONObject();
            if (Objects.nonNull(paramObject)) {
                paramJson.putAll((Map)JSON.parseObject((String)JSON.toJSONStringWithDateFormat(paramObject, (String)JSON.DEFFAULT_DATE_FORMAT, (SerializerFeature[])new SerializerFeature[0])));
            }
            if (Objects.nonNull(pageable)) {
                paramJson.putAll((Map)JSON.parseObject((String)JSON.toJSONString((Object)pageable)));
            }
            paramJson.put("merchantId", (Object)this.properties.getMerchantId());
            if (!paramJson.isEmpty()) {
                for (Map.Entry entry : paramJson.entrySet()) {
                    if (Objects.nonNull(entry.getValue()) && entry.getValue() instanceof Collection) {
                        builder.queryParam((String)entry.getKey(), new Object[]{String.join((CharSequence)",", (Collection)entry.getValue())});
                        continue;
                    }
                    builder.queryParam((String)entry.getKey(), new Object[]{URLEncoder.encode(entry.getValue().toString(), "UTF-8")});
                }
            }
            UriComponents components = builder.build(true);
            URI uri = components.toUri();
            result = (Result)this.restTemplate.getForObject(uri, Result.class);
            Validate.notNull((Object)result, (String)"\u7ed3\u679c\u5f02\u5e38", (Object[])new Object[0]);
        }
        catch (Exception e) {
            log.error("\u7a0e\u7b79\u5e73\u53f0\u8bf7\u6c42\u9519\u8bef", (Throwable)e);
            throw new IllegalArgumentException("\u7cfb\u7edf\u7e41\u5fd9,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        Validate.isTrue((boolean)result.isSuccess(), (String)result.getMessage(), (Object[])new Object[0]);
        return result;
    }

    protected <T extends BaseTaxRaiseDto> Result doPost(String url, T paramBody) {
        Result result;
        try {
            UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)String.format("%s/%s", this.properties.getHost(), url));
            UriComponents components = builder.build(true);
            URI uri = components.toUri();
            JSONObject bodyJson = new JSONObject();
            if (Objects.nonNull(paramBody)) {
                bodyJson.putAll((Map)JSON.parseObject((String)JSON.toJSONStringWithDateFormat(paramBody, (String)JSON.DEFFAULT_DATE_FORMAT, (SerializerFeature[])new SerializerFeature[0])));
            }
            bodyJson.put("merchantId", (Object)this.properties.getMerchantId());
            result = (Result)this.restTemplate.postForEntity(uri, (Object)bodyJson, Result.class).getBody();
            Validate.notNull((Object)result, (String)"\u7ed3\u679c\u5f02\u5e38", (Object[])new Object[0]);
        }
        catch (Exception e) {
            log.error("\u7a0e\u7b79\u5e73\u53f0\u8bf7\u6c42\u9519\u8bef", (Throwable)e);
            throw new IllegalArgumentException("\u7cfb\u7edf\u7e41\u5fd9,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        Validate.isTrue((boolean)result.isSuccess(), (String)result.getMessage(), (Object[])new Object[0]);
        return result;
    }
}

