/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.external.tax.raise.local.service.capital.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.LoginUserDetailsForCPS;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.external.tax.raise.local.client.capital.TaxRaiseCapitalAccountClient;
import com.biz.crm.cps.external.tax.raise.sdk.dto.base.MerchantAccountDto;
import com.biz.crm.cps.external.tax.raise.sdk.dto.capital.TaxDeductionAmountDto;
import com.biz.crm.cps.external.tax.raise.sdk.dto.capital.TaxRaiseCapitalAccountQueryDto;
import com.biz.crm.cps.external.tax.raise.sdk.service.capital.TaxRaiseCapitalAccountVoService;
import com.biz.crm.cps.external.tax.raise.sdk.vo.capital.TaxRaiseCapitalAccountVo;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TaxRaiseCapitalAccountVoServiceImpl
implements TaxRaiseCapitalAccountVoService {
    private static final Logger log = LoggerFactory.getLogger(TaxRaiseCapitalAccountVoServiceImpl.class);
    @Autowired
    private TaxRaiseCapitalAccountClient taxRaiseCapitalAccountClient;
    @Autowired
    private LoginUserService loginUserService;

    public Page<TaxRaiseCapitalAccountVo> findByConditions(Pageable pageable, TaxRaiseCapitalAccountQueryDto dto) {
        dto.setMerchantUserAccount(dto.getAccountCode());
        dto.setAccountCode(null);
        return this.taxRaiseCapitalAccountClient.findByConditions(pageable, dto);
    }

    public TaxRaiseCapitalAccountVo findByCurrentUser() {
        LoginUserDetailsForCPS loginDetails = (LoginUserDetailsForCPS)this.loginUserService.getLoginDetails(LoginUserDetailsForCPS.class);
        Validate.notNull((Object)loginDetails, (String)"\u672a\u83b7\u53d6\u5230\u7528\u6237\u767b\u5f55\u4fe1\u606f", (Object[])new Object[0]);
        MerchantAccountDto merchantAccountDto = new MerchantAccountDto();
        merchantAccountDto.setMerchantUserAccount(loginDetails.getAccount());
        return this.taxRaiseCapitalAccountClient.findByMerchantUserAccount(merchantAccountDto);
    }

    @Transactional
    public void deductAmountByDeductionAmountDto(TaxDeductionAmountDto dto) {
        Validate.notNull((Object)dto, (String)"\u6263\u51cf\u8d26\u6237\u8d44\u91d1\u65f6,\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.taxRaiseCapitalAccountClient.deductAmountByDeductionAmountDto(dto);
    }

    public TaxRaiseCapitalAccountVo findByMerchantUserAccount(String merchantUserAccount) {
        if (StringUtils.isBlank((CharSequence)merchantUserAccount)) {
            return new TaxRaiseCapitalAccountVo();
        }
        MerchantAccountDto merchantAccountDto = new MerchantAccountDto();
        merchantAccountDto.setMerchantUserAccount(merchantUserAccount);
        return this.taxRaiseCapitalAccountClient.findByMerchantUserAccount(merchantAccountDto);
    }
}

