/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.external.tax.raise.local.service.capital.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.LoginUserDetailsForCPS;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.business.capital.sdk.common.enums.DataSourceEnum;
import com.biz.crm.cps.business.capital.sdk.service.CapitalRechargeVoService;
import com.biz.crm.cps.business.capital.sdk.vo.CapitalRechargeVo;
import com.biz.crm.cps.external.tax.raise.local.client.capital.TaxRaiseRechargeClient;
import com.biz.crm.cps.external.tax.raise.local.config.TaxRaiseProperties;
import com.biz.crm.cps.external.tax.raise.sdk.dto.capital.TaxRaiseRechargeBatchDto;
import com.biz.crm.cps.external.tax.raise.sdk.dto.capital.TaxRaiseRechargeDto;
import com.biz.crm.cps.external.tax.raise.sdk.dto.capital.TaxRaiseRechargeQueryDto;
import com.biz.crm.cps.external.tax.raise.sdk.service.capital.TaxRaiseRechargeVoService;
import com.biz.crm.cps.external.tax.raise.sdk.vo.capital.TaxRaiseRechargeVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TaxRaiseRechargeVoServiceImpl
implements TaxRaiseRechargeVoService {
    private static final Logger log = LoggerFactory.getLogger(TaxRaiseRechargeVoServiceImpl.class);
    @Autowired
    private TaxRaiseRechargeClient taxRaiseRechargeClient;
    @Autowired
    private CapitalRechargeVoService capitalRechargeVoService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private LoginUserService loginUserService;
    @Autowired
    private TaxRaiseProperties properties;

    @Transactional
    public TaxRaiseRechargeVo create(TaxRaiseRechargeDto dto) {
        return this.taxRaiseRechargeClient.create(dto);
    }

    @Transactional
    public TaxRaiseRechargeVo pushByRechargeCode(String rechargeCode) {
        Validate.notBlank((CharSequence)rechargeCode, (String)"\u6839\u636e\u5145\u503c\u7f16\u53f7\u624b\u52a8\u63a8\u9001\u5145\u503c\u4fe1\u606f\u65f6,\u5145\u503c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        CapitalRechargeVo capitalRechargeVo = this.capitalRechargeVoService.findByRechargeCode(rechargeCode);
        Validate.notBlank((CharSequence)rechargeCode, (String)"\u6839\u636e\u5145\u503c\u7f16\u53f7\u624b\u52a8\u63a8\u9001\u5145\u503c\u4fe1\u606f\u65f6,\u672a\u67e5\u8be2\u5230\u5145\u503c\u4fe1\u606f", (Object[])new Object[0]);
        TaxRaiseRechargeDto taxRaiseRechargeDto = (TaxRaiseRechargeDto)this.nebulaToolkitService.copyObjectByBlankList((Object)capitalRechargeVo, TaxRaiseRechargeDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        taxRaiseRechargeDto.setDataSource(DataSourceEnum.CPS_PUSH.getDictCode());
        TaxRaiseRechargeVo taxRaiseRechargeVo = this.taxRaiseRechargeClient.create(taxRaiseRechargeDto);
        this.capitalRechargeVoService.updatePushStatusByRechargeCodes(Arrays.asList(rechargeCode));
        return taxRaiseRechargeVo;
    }

    public Page<TaxRaiseRechargeVo> findByConditions(Pageable pageable, TaxRaiseRechargeQueryDto dto) {
        LoginUserDetailsForCPS loginDetails = (LoginUserDetailsForCPS)this.loginUserService.getLoginDetails(LoginUserDetailsForCPS.class);
        Validate.notNull((Object)loginDetails, (String)"\u672a\u83b7\u53d6\u5230\u7528\u6237\u767b\u5f55\u4fe1\u606f", (Object[])new Object[0]);
        dto.setMerchantUserAccount(loginDetails.getAccount());
        return this.taxRaiseRechargeClient.findByConditions(pageable, dto);
    }

    public void pushRechargeBatch(List<TaxRaiseRechargeDto> taxRaiseRechargeDtos) {
        Validate.notEmpty(taxRaiseRechargeDtos, (String)"\u63a8\u9001\u5145\u503c\u6570\u636e\u5230\u7a0e\u7b79\u5e73\u53f0\u65f6,\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        for (TaxRaiseRechargeDto taxRaiseRechargeDto : taxRaiseRechargeDtos) {
            taxRaiseRechargeDto.setDataSource(DataSourceEnum.CPS_PUSH.getDictCode());
            taxRaiseRechargeDto.setReturnUrl(this.properties.getCapitalRechargeReturnUrl());
        }
        TaxRaiseRechargeBatchDto taxRaiseRechargeBatchDto = new TaxRaiseRechargeBatchDto();
        taxRaiseRechargeBatchDto.setTaxRaiseRechargeDtos(taxRaiseRechargeDtos);
        this.taxRaiseRechargeClient.createBatch(taxRaiseRechargeBatchDto);
        List rechargeCodes = taxRaiseRechargeDtos.stream().map(TaxRaiseRechargeDto::getRechargeCode).collect(Collectors.toList());
        this.capitalRechargeVoService.updatePushStatusByRechargeCodes(rechargeCodes);
    }
}

