/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.external.tax.raise.local.service.recharge.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.LoginUserDetailsForCPS;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.external.tax.raise.local.client.recharge.TaxRaiseRechargeAccountClient;
import com.biz.crm.cps.external.tax.raise.local.config.TaxRaiseProperties;
import com.biz.crm.cps.external.tax.raise.sdk.dto.base.MerchantAccountBatchDto;
import com.biz.crm.cps.external.tax.raise.sdk.dto.base.MerchantAccountDto;
import com.biz.crm.cps.external.tax.raise.sdk.dto.base.TaxRaiseCustomerDto;
import com.biz.crm.cps.external.tax.raise.sdk.dto.recharge.TaxRaiseRechargeAccountDto;
import com.biz.crm.cps.external.tax.raise.sdk.dto.recharge.TaxRaiseRechargeAccountPageDto;
import com.biz.crm.cps.external.tax.raise.sdk.enums.recharge.TaxRaiseRechargeAccountTypeEnum;
import com.biz.crm.cps.external.tax.raise.sdk.service.recharge.TaxRaiseRechargeAccountVoService;
import com.biz.crm.cps.external.tax.raise.sdk.vo.recharge.TaxRaiseRechargeAccountVo;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class TaxRaiseRechargeAccountVoServiceImpl
implements TaxRaiseRechargeAccountVoService {
    private static final Logger log = LoggerFactory.getLogger(TaxRaiseRechargeAccountVoServiceImpl.class);
    @Autowired
    private TaxRaiseRechargeAccountClient taxRaiseRechargeAccountClient;
    @Autowired
    private LoginUserService loginUserService;
    @Autowired
    private TaxRaiseProperties properties;

    public TaxRaiseRechargeAccountVo findByMerchantAccountDto(MerchantAccountDto dto) {
        return this.taxRaiseRechargeAccountClient.findByMerchantAccountDto(dto);
    }

    public TaxRaiseRechargeAccountVo findCurrentByMerchantAccountDto() {
        MerchantAccountDto dto = new MerchantAccountDto();
        LoginUserDetailsForCPS loginUser = (LoginUserDetailsForCPS)this.loginUserService.getLoginDetails(LoginUserDetailsForCPS.class);
        Validate.notNull((Object)loginUser, (String)"\u672a\u67e5\u8be2\u5230\u5f53\u524d\u767b\u5f55\u4fe1\u606f", (Object[])new Object[0]);
        dto.setMerchantUserAccount(loginUser.getAccount());
        return this.taxRaiseRechargeAccountClient.findByMerchantAccountDto(dto);
    }

    public List<TaxRaiseRechargeAccountVo> findByMerchantAccountBatchDto(MerchantAccountBatchDto dto) {
        return this.taxRaiseRechargeAccountClient.findByMerchantAccountBatchDto(dto);
    }

    public Page<TaxRaiseRechargeAccountVo> findByConditions(Pageable pageable, TaxRaiseRechargeAccountPageDto dto) {
        return this.taxRaiseRechargeAccountClient.findByConditions(pageable, dto);
    }

    public TaxRaiseRechargeAccountVo create(TaxRaiseRechargeAccountDto dto) {
        return this.taxRaiseRechargeAccountClient.create(dto);
    }

    public TaxRaiseRechargeAccountVo createByBrandBusiness() {
        TaxRaiseRechargeAccountDto dto = new TaxRaiseRechargeAccountDto();
        dto.setAccountType(TaxRaiseRechargeAccountTypeEnum.COMPANY.getDictCode());
        dto.setMerchantUserAccount(this.properties.getBrandDefaultAccount());
        this.taxRaiseRechargeAccountClient.create(dto);
        return this.taxRaiseRechargeAccountClient.findByMerchantAccountDto((MerchantAccountDto)dto);
    }

    public String downloadIdentification(TaxRaiseCustomerDto dto) {
        return this.taxRaiseRechargeAccountClient.downloadIdentification(dto);
    }

    public String downloadBusinessLicense(TaxRaiseCustomerDto dto) {
        return this.taxRaiseRechargeAccountClient.downloadBusinessLicense(dto);
    }
}

