/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.external.tax.raise.local.service.recharge.internal;

import com.biz.crm.cps.external.tax.raise.local.client.recharge.TaxRaiseRechargeAccountClient;
import com.biz.crm.cps.external.tax.raise.local.client.recharge.TaxRaiseRechargeContractSignClient;
import com.biz.crm.cps.external.tax.raise.local.client.recharge.TaxRaiseRechargeContractTemplateClient;
import com.biz.crm.cps.external.tax.raise.local.config.TaxRaiseProperties;
import com.biz.crm.cps.external.tax.raise.sdk.dto.base.MerchantAccountDto;
import com.biz.crm.cps.external.tax.raise.sdk.dto.recharge.TaxRaiseRechargeContractSignDto;
import com.biz.crm.cps.external.tax.raise.sdk.enums.recharge.TaxRaiseRechargeCompanyVerifyStatusEnum;
import com.biz.crm.cps.external.tax.raise.sdk.service.recharge.TaxRaiseRechargeContractSignVoService;
import com.biz.crm.cps.external.tax.raise.sdk.vo.recharge.TaxRaiseRechargeAccountVo;
import com.biz.crm.cps.external.tax.raise.sdk.vo.recharge.TaxRaiseRechargeContractSignVo;
import com.biz.crm.cps.external.tax.raise.sdk.vo.recharge.TaxRaiseRechargeContractTemplateVo;
import java.util.Objects;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TaxRaiseRechargeContractSignVoServiceImpl
implements TaxRaiseRechargeContractSignVoService {
    private static final Logger log = LoggerFactory.getLogger(TaxRaiseRechargeContractSignVoServiceImpl.class);
    @Autowired
    private TaxRaiseRechargeContractSignClient taxRaiseRechargeContractSignClient;
    @Autowired
    private TaxRaiseProperties properties;
    @Autowired
    private TaxRaiseRechargeAccountClient taxRaiseRechargeAccountClient;
    @Autowired
    private TaxRaiseRechargeContractTemplateClient taxRaiseRechargeContractTemplateClient;

    public TaxRaiseRechargeContractSignVo findByTaxRaiseRechargeContractSignDto(TaxRaiseRechargeContractSignDto dto) {
        return this.taxRaiseRechargeContractSignClient.findByTaxRaiseRechargeContractSignDto(dto);
    }

    public TaxRaiseRechargeContractSignVo create(TaxRaiseRechargeContractSignDto dto) {
        return this.taxRaiseRechargeContractSignClient.create(dto);
    }

    public TaxRaiseRechargeContractSignVo createByBrandBusiness() {
        TaxRaiseRechargeContractSignDto dto = new TaxRaiseRechargeContractSignDto();
        dto.setMerchantUserAccount(this.properties.getBrandDefaultAccount());
        TaxRaiseRechargeAccountVo accountVo = this.taxRaiseRechargeAccountClient.findByMerchantAccountDto((MerchantAccountDto)dto);
        Validate.isTrue((Objects.nonNull(accountVo) && TaxRaiseRechargeCompanyVerifyStatusEnum.PASSED.getDictCode().equals(accountVo.getCompanyStatus()) ? 1 : 0) != 0, (String)"\u8fd8\u672a\u901a\u8fc7\u4f01\u4e1a\u5b9e\u540d\u8ba4\u8bc1,\u65e0\u6cd5\u7b7e\u7f72\u5408\u540c", (Object[])new Object[0]);
        TaxRaiseRechargeContractTemplateVo templateVo = this.taxRaiseRechargeContractTemplateClient.findByMerchantAccountDto((MerchantAccountDto)dto);
        Validate.notNull((Object)templateVo, (String)"\u672a\u67e5\u8be2\u5230\u5408\u540c\u6a21\u677f\uff01", (Object[])new Object[0]);
        dto.setTemplateCode(templateVo.getTemplateCode());
        TaxRaiseRechargeContractSignVo contractSignVo = this.taxRaiseRechargeContractSignClient.findByTaxRaiseRechargeContractSignDto(dto);
        if (Objects.isNull(contractSignVo)) {
            contractSignVo = this.taxRaiseRechargeContractSignClient.create(dto);
        }
        return contractSignVo;
    }
}

