package com.biz.crm.cps.external.tax.raise.sdk.dto.capital;

import com.biz.crm.cps.external.tax.raise.sdk.dto.base.MerchantAccountDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 扣减账户余额dto
 * @Author: wjx
 * @Date: 2022/3/30 14:49
 */
@Data
@ApiModel(value = "DeductionAmountDto", description = "扣减账户余额dto")
public class TaxDeductionAmountDto extends MerchantAccountDto {

  /**
   * 商户ID
   */
  @ApiModelProperty("商户ID")
  private String merchantId;

  /**
   * 商户平台用户账户(cps账号)
   */
  @ApiModelProperty("商户平台用户账户")
  private String merchantUserAccount;

  /**
   * 账户编号(税筹)
   */
  @ApiModelProperty("账户编号")
  private String accountCode;

  /**
   * 变更金额
   */
  @ApiModelProperty(value = "变更金额")
  BigDecimal changeAmount;

  /**
   * 业务类型
   */
  @ApiModelProperty(value = "业务类型")
  String businessType;

  /**
   * 关联单据编号
   */
  @ApiModelProperty(value = "关联单据编号")
  String relevanceCode;



}
