package com.biz.crm.cps.external.tax.raise.sdk.dto.capital;

import com.biz.crm.cps.external.tax.raise.sdk.dto.base.MerchantAccountDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * 账号资金信息查询dto
 * @Author: wjx
 * @Date: 2022/3/23 17:04
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "TaxRaiseRechargeDto", description = "账号资金信息参数dto")
public class TaxRaiseCapitalAccountQueryDto extends MerchantAccountDto {

  /**
   * 商户平台id
   */
  @ApiModelProperty(value = "商户平台id")
  private String merchantId;

  /**
   * 商户平台名称
   */
  @ApiModelProperty(value = "商户平台名称")
  private String merchantName;

  /**
   * 认证编码
   */
  @ApiModelProperty("认证编码")
  private String customerId;

  /**
   * 商户平台用户账户
   */
  @ApiModelProperty("商户平台用户账户")
  private String merchantUserAccount;

  /**
   * 账户编码
   */
  @ApiModelProperty("账户编码")
  private String accountCode;

  /**
   * 账户名称
   */
  @ApiModelProperty("账户名称")
  private String accountName;

  /**
   * 账户类型 FadadaRechargeAccountTypeEnum 1:个⼈ 2:企业
   */
  @ApiModelProperty("账户类型")
  private String accountType;

  /**
   * 创建开始时间
   */
  @ApiModelProperty("创建开始时间")
  @JsonFormat(locale="zh", timezone="GMT+8", pattern="yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss" )
  private Date startCreateTime;

  /**
   * 创建结束时间
   */
  @ApiModelProperty("创建结束时间")
  @JsonFormat(locale="zh", timezone="GMT+8", pattern="yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss" )
  private Date endCreateTime;
}
