package com.biz.crm.cps.external.tax.raise.sdk.dto.capital;

import com.biz.crm.cps.external.tax.raise.sdk.dto.base.MerchantAccountDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * 账号资金收支明细dto
 * @Author: wjx
 * @Date: 2022/3/23 17:04
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "TaxRaiseCapitalAccountTransactionQueryDto", description = "账号资金收支明细dto")
public class TaxRaiseCapitalAccountTransactionQueryDto extends MerchantAccountDto {

  /**
   * 交易编号
   */
  @ApiModelProperty("交易编号")
  private String transactionCode;

  /**
   * 账户编码
   */
  @ApiModelProperty("账户编码")
  private String accountCode;

  /**
   * 账户名称
   */
  @ApiModelProperty("账户名称")
  private String accountName;

  /**
   * 交易类型
   */
  @ApiModelProperty("交易类型")
  private String transactionType;

  /**
   * 业务类型
   */
  @ApiModelProperty("业务类型")
  private String businessType;

  /**
   * 创建开始时间
   */
  @ApiModelProperty(name = "startCreateTime", value = "创建开始时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date startCreateTime;

  /**
   * 创建结束时间
   */
  @ApiModelProperty(name = "endCreateTime", value = "创建结束时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date endCreateTime;
}
